/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpandProperties
implements Function<Properties, Properties> {
    private static final Pattern VAR = Pattern.compile("\\$\\{[^\\}]+\\}");

    public Properties apply(final Properties properties) {
        Map<String, String> leafs;
        Preconditions.checkNotNull((Object)properties, (Object)"properties cannot be null");
        ImmutableMap stringProperties = Maps.toMap(properties.stringPropertyNames(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return properties.getProperty(input);
            }
        });
        boolean pendingReplacements = true;
        HashMap<String, String> propertiesToResolve = new HashMap<String, String>((Map<String, String>)stringProperties);
        while (pendingReplacements && !(leafs = this.leafs(propertiesToResolve)).isEmpty()) {
            pendingReplacements = this.resolveProperties(propertiesToResolve, leafs);
        }
        Properties resolved = new Properties();
        resolved.putAll((Map<?, ?>)properties);
        for (Map.Entry entry : propertiesToResolve.entrySet()) {
            resolved.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return resolved;
    }

    private Map<String, String> leafs(Map<String, String> input) {
        return Maps.filterValues(input, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                Matcher m = VAR.matcher(input);
                return !m.find();
            }
        });
    }

    private boolean resolveProperties(Map<String, String> properties, Map<String, String> variables) {
        boolean anyReplacementDone = false;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            StringBuffer sb = new StringBuffer();
            Matcher m = VAR.matcher(entry.getValue());
            while (m.find()) {
                String match = m.group();
                String var = match.substring(2, match.length() - 1);
                Optional value = var.equals(key) ? Optional.absent() : Optional.fromNullable((Object)variables.get(var));
                m.appendReplacement(sb, (String)value.or((Object)("\\" + match)));
                if (!value.isPresent()) continue;
                anyReplacementDone = true;
            }
            m.appendTail(sb);
            properties.put(key, sb.toString());
        }
        return anyReplacementDone;
    }
}

