/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.VirtualizationType;

public class EC2HardwareBuilder
extends HardwareBuilder {
    private Predicate<Image> rootDeviceType = ImagePredicates.any();
    private Predicate<Image> virtualizationType = null;
    private Predicate<Image> imageIds = ImagePredicates.any();
    private Predicate<Image> is64Bit = ImagePredicates.any();

    public EC2HardwareBuilder() {
        this.supportsImage = null;
    }

    public EC2HardwareBuilder(String instanceType) {
        this.ids(instanceType);
    }

    public EC2HardwareBuilder virtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = new RequiresVirtualizationType(virtualizationType);
        return this;
    }

    public EC2HardwareBuilder virtualizationTypes(VirtualizationType ... virtualizationTypes) {
        Preconditions.checkNotNull((Object)virtualizationTypes, (Object)"virtualizationTypes");
        Preconditions.checkArgument((virtualizationTypes.length > 0 ? 1 : 0) != 0, (Object)"At least one virtualization type is required.");
        if (virtualizationTypes.length == 1) {
            this.virtualizationType = new RequiresVirtualizationType(virtualizationTypes[0]);
        } else {
            ArrayList supportedVirtualizationTypes = Lists.newArrayList();
            for (VirtualizationType virtualizationType : virtualizationTypes) {
                supportedVirtualizationTypes.add(new RequiresVirtualizationType((VirtualizationType)((Object)Preconditions.checkNotNull((Object)((Object)virtualizationType), (Object)"virtualizationType"))));
            }
            this.virtualizationType = Predicates.or((Iterable)supportedVirtualizationTypes);
        }
        return this;
    }

    public EC2HardwareBuilder rootDeviceType(RootDeviceType rootDeviceType) {
        this.rootDeviceType = new RequiresRootDeviceType(rootDeviceType);
        return this;
    }

    public EC2HardwareBuilder supportsImageIds(Iterable<String> ids) {
        this.imageIds = ImagePredicates.idIn(ids);
        return this;
    }

    public EC2HardwareBuilder ids(String id) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.ids(id)));
    }

    public EC2HardwareBuilder ram(int ram) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.ram(ram)));
    }

    public EC2HardwareBuilder processors(List<Processor> processors) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.processors(processors)));
    }

    public EC2HardwareBuilder volumes(List<Volume> volumes) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.volumes(volumes)));
    }

    public EC2HardwareBuilder supportsImage(Predicate<Image> supportsImage) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.supportsImage(supportsImage)));
    }

    public EC2HardwareBuilder is64Bit(boolean is64Bit) {
        this.is64Bit = is64Bit ? ImagePredicates.is64Bit() : Predicates.not((Predicate)ImagePredicates.is64Bit());
        return this;
    }

    public EC2HardwareBuilder id(String id) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.id(id)));
    }

    public EC2HardwareBuilder providerId(String providerId) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.providerId(providerId)));
    }

    public EC2HardwareBuilder name(String name) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.name(name)));
    }

    public EC2HardwareBuilder location(Location location) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.location(location)));
    }

    public EC2HardwareBuilder uri(URI uri) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.uri(uri)));
    }

    public EC2HardwareBuilder userMetadata(Map<String, String> userMetadata) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.userMetadata(userMetadata)));
    }

    private EC2HardwareBuilder t2() {
        this.virtualizationTypes(VirtualizationType.HVM);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder t3() {
        this.virtualizationType(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder m3() {
        this.virtualizationTypes(VirtualizationType.HVM, VirtualizationType.PARAVIRTUAL);
        return this;
    }

    private EC2HardwareBuilder m4() {
        this.virtualizationTypes(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder m5() {
        this.virtualizationTypes(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder c3() {
        this.virtualizationTypes(VirtualizationType.HVM, VirtualizationType.PARAVIRTUAL);
        return this;
    }

    private EC2HardwareBuilder c4() {
        this.virtualizationTypes(VirtualizationType.HVM, VirtualizationType.PARAVIRTUAL);
        return this;
    }

    private EC2HardwareBuilder c5() {
        this.virtualizationTypes(VirtualizationType.HVM, VirtualizationType.PARAVIRTUAL);
        return this;
    }

    private EC2HardwareBuilder d2() {
        this.virtualizationTypes(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder r3() {
        this.virtualizationTypes(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder r4() {
        this.virtualizationTypes(VirtualizationType.HVM);
        this.rootDeviceType(RootDeviceType.EBS);
        return this;
    }

    private EC2HardwareBuilder g2() {
        this.virtualizationTypes(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder i2() {
        this.virtualizationTypes(VirtualizationType.HVM);
        return this;
    }

    private EC2HardwareBuilder hs1() {
        this.virtualizationTypes(VirtualizationType.HVM, VirtualizationType.PARAVIRTUAL);
        return this;
    }

    private EC2HardwareBuilder x1() {
        this.virtualizationTypes(VirtualizationType.HVM);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder m1() {
        this.virtualizationTypes(VirtualizationType.PARAVIRTUAL);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder c1() {
        this.virtualizationTypes(VirtualizationType.PARAVIRTUAL);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder cc2() {
        this.virtualizationTypes(VirtualizationType.HVM);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder m2() {
        this.virtualizationTypes(VirtualizationType.PARAVIRTUAL);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder hi1() {
        this.virtualizationTypes(VirtualizationType.HVM, VirtualizationType.PARAVIRTUAL);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder t1() {
        this.virtualizationTypes(VirtualizationType.PARAVIRTUAL);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder cg1() {
        this.virtualizationTypes(VirtualizationType.HVM);
        this.deprecated();
        return this;
    }

    private EC2HardwareBuilder cc1() {
        this.virtualizationTypes(VirtualizationType.HVM);
        this.deprecated();
        return this;
    }

    public static EC2HardwareBuilder m1_small() {
        return new EC2HardwareBuilder("m1.small").m1().ram(1740).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(150.0f)).device("/dev/sda2").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m1_medium() {
        return new EC2HardwareBuilder("m1.medium").m1().ram(3750).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 2.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder t1_micro() {
        return new EC2HardwareBuilder("t1.micro").t1().ram(630).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 1.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_nano() {
        return new EC2HardwareBuilder("t2.nano").t2().ram(512).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 3.3))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_micro() {
        return new EC2HardwareBuilder("t2.micro").t2().ram(1024).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 3.3))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_small() {
        return new EC2HardwareBuilder("t2.small").t2().ram(2048).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 3.3))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_medium() {
        return new EC2HardwareBuilder("t2.medium").t2().ram(4096).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.3))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_large() {
        return new EC2HardwareBuilder("t2.large").t2().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_xlarge() {
        return new EC2HardwareBuilder("t2.xlarge").t2().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t2_2xlarge() {
        return new EC2HardwareBuilder("t2.2xlarge").t2().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_nano() {
        return new EC2HardwareBuilder("t3.nano").t3().ram(512).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_micro() {
        return new EC2HardwareBuilder("t3.micro").t3().ram(1024).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_small() {
        return new EC2HardwareBuilder("t3.small").t3().ram(2048).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_medium() {
        return new EC2HardwareBuilder("t3.medium").t3().ram(4096).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_large() {
        return new EC2HardwareBuilder("t3.large").t3().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_xlarge() {
        return new EC2HardwareBuilder("t3.xlarge").t3().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder t3_2xlarge() {
        return new EC2HardwareBuilder("t3.2xlarge").t3().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m1_large() {
        return new EC2HardwareBuilder("m1.large").m1().ram(7680).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m1_xlarge() {
        return new EC2HardwareBuilder("m1.xlarge").m1().ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_xlarge() {
        return new EC2HardwareBuilder("m2.xlarge").m2().ram(17510).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sda1").bootDevice(true).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_2xlarge() {
        return new EC2HardwareBuilder("m2.2xlarge").m2().ram(35020).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_4xlarge() {
        return new EC2HardwareBuilder("m2.4xlarge").m2().ram(70041).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m3_medium() {
        return new EC2HardwareBuilder("m3.medium").m3().ram(3840).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(4.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m3_large() {
        return new EC2HardwareBuilder("m3.large").m3().ram(7680).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(32.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m3_xlarge() {
        return new EC2HardwareBuilder("m3.xlarge").m3().ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.25))).is64Bit(true).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m3_2xlarge() {
        return new EC2HardwareBuilder("m3.2xlarge").m3().ram(30720).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).is64Bit(true).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m4_xlarge() {
        return new EC2HardwareBuilder("m4.xlarge").m4().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.25))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m4_large() {
        return new EC2HardwareBuilder("m4.large").m4().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.25))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m4_2xlarge() {
        return new EC2HardwareBuilder("m4.2xlarge").m4().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m4_4xlarge() {
        return new EC2HardwareBuilder("m4.4xlarge").m4().ram(65536).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.34375))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m4_10xlarge() {
        return new EC2HardwareBuilder("m4.10xlarge").m4().ram(163840).processors((List<Processor>)ImmutableList.of((Object)new Processor(40.0, 3.1125))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m4_16xlarge() {
        return new EC2HardwareBuilder("m4.16xlarge").m4().ram(262144).processors((List<Processor>)ImmutableList.of((Object)new Processor(64.0, 3.1125))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5_large() {
        return new EC2HardwareBuilder("m5.large").m5().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5_xlarge() {
        return new EC2HardwareBuilder("m5.xlarge").m5().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.5))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5_2xlarge() {
        return new EC2HardwareBuilder("m5.2xlarge").m5().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.5))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5_4xlarge() {
        return new EC2HardwareBuilder("m5.4xlarge").m5().ram(65536).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.5))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5_12xlarge() {
        return new EC2HardwareBuilder("m5.12xlarge").m5().ram(196608).processors((List<Processor>)ImmutableList.of((Object)new Processor(48.0, 2.5))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5_24xlarge() {
        return new EC2HardwareBuilder("m5.24xlarge").m5().ram(393216).processors((List<Processor>)ImmutableList.of((Object)new Processor(96.0, 2.5))).is64Bit(true).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m5d_large() {
        return new EC2HardwareBuilder("m5d.large").m5().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(75.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m5d_xlarge() {
        return new EC2HardwareBuilder("m5d.xlarge").m5().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(150.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m5d_2xlarge() {
        return new EC2HardwareBuilder("m5d.2xlarge").m5().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(300.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m5d_4xlarge() {
        return new EC2HardwareBuilder("m5d.4xlarge").m5().ram(65536).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(300.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(300.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m5d_12xlarge() {
        return new EC2HardwareBuilder("m5d.12xlarge").m5().ram(196608).processors((List<Processor>)ImmutableList.of((Object)new Processor(48.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m5d_24xlarge() {
        return new EC2HardwareBuilder("m5d.24xlarge").m5().ram(393216).processors((List<Processor>)ImmutableList.of((Object)new Processor(96.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c1_medium() {
        return new EC2HardwareBuilder("c1.medium").c1().ram(1740).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(340.0f)).device("/dev/sda2").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder c1_xlarge() {
        return new EC2HardwareBuilder("c1.xlarge").c1().ram(7168).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_large() {
        return new EC2HardwareBuilder("c3.large").c3().ram(3750).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(16.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(16.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_xlarge() {
        return new EC2HardwareBuilder("c3.xlarge").c3().ram(7168).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_2xlarge() {
        return new EC2HardwareBuilder("c3.2xlarge").c3().ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_4xlarge() {
        return new EC2HardwareBuilder("c3.4xlarge").c3().ram(30720).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.4375))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(160.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(160.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_8xlarge() {
        return new EC2HardwareBuilder("c3.8xlarge").c3().ram(61440).processors((List<Processor>)ImmutableList.of((Object)new Processor(32.0, 3.375))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c4_large() {
        return new EC2HardwareBuilder("c4.large").c4().ram(3840).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c4_xlarge() {
        return new EC2HardwareBuilder("c4.xlarge").c4().ram(7680).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c4_2xlarge() {
        return new EC2HardwareBuilder("c4.2xlarge").c4().ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c4_4xlarge() {
        return new EC2HardwareBuilder("c4.4xlarge").c4().ram(30720).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c4_8xlarge() {
        return new EC2HardwareBuilder("c4.8xlarge").c4().ram(61440).processors((List<Processor>)ImmutableList.of((Object)new Processor(36.0, 3.5))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5_large() {
        return new EC2HardwareBuilder("c5.large").c5().ram(4096).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5_xlarge() {
        return new EC2HardwareBuilder("c5.xlarge").c5().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5_2xlarge() {
        return new EC2HardwareBuilder("c5.2xlarge").c5().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5_4xlarge() {
        return new EC2HardwareBuilder("c5.4xlarge").c5().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5_9xlarge() {
        return new EC2HardwareBuilder("c5.9xlarge").c5().ram(73728).processors((List<Processor>)ImmutableList.of((Object)new Processor(36.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5_18xlarge() {
        return new EC2HardwareBuilder("c5.18xlarge").c5().ram(147456).processors((List<Processor>)ImmutableList.of((Object)new Processor(72.0, 3.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder c5d_large() {
        return new EC2HardwareBuilder("c5d.large").c5().ram(4096).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(50.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c5d_xlarge() {
        return new EC2HardwareBuilder("c5d.xlarge").c5().ram(8192).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(100.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c5d_2xlarge() {
        return new EC2HardwareBuilder("c5d.2xlarge").c5().ram(16384).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(225.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c5d_4xlarge() {
        return new EC2HardwareBuilder("c5d.4xlarge").c5().ram(32768).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(450.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c5d_9xlarge() {
        return new EC2HardwareBuilder("c5d.9xlarge").c5().ram(73728).processors((List<Processor>)ImmutableList.of((Object)new Processor(36.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c5d_18xlarge() {
        return new EC2HardwareBuilder("c5d.18xlarge").c5().ram(147456).processors((List<Processor>)ImmutableList.of((Object)new Processor(72.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(900.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder d2_xlarge() {
        return new EC2HardwareBuilder("d2.xlarge").d2().ram(31232).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdd").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder d2_2xlarge() {
        return new EC2HardwareBuilder("d2.2xlarge").d2().ram(62464).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sde").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdf").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdg").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder d2_4xlarge() {
        return new EC2HardwareBuilder("d2.4xlarge").d2().ram(124928).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sde").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdf").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdg").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdh").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdi").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdj").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdk").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdl").bootDevice(false).durable(false).build(), (Object[])new Volume[]{new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdm").bootDevice(false).durable(false).build()})).is64Bit(true);
    }

    public static EC2HardwareBuilder d2_8xlarge() {
        return new EC2HardwareBuilder("d2.8xlarge").d2().ram(249856).processors((List<Processor>)ImmutableList.of((Object)new Processor(36.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sde").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdf").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdg").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdh").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdi").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdj").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdk").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdl").bootDevice(false).durable(false).build(), (Object[])new Volume[]{new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdm").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdn").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdo").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdp").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdq").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdr").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sds").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdt").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdu").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdv").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdw").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdx").bootDevice(false).durable(false).build(), new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(2000.0f)).device("/dev/sdy").bootDevice(false).durable(false).build()})).is64Bit(true);
    }

    public static EC2HardwareBuilder cg1_4xlarge() {
        return new EC2HardwareBuilder("cg1.4xlarge").cg1().ram(22528).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 4.0), (Object)new Processor(4.0, 4.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder cc1_4xlarge() {
        return new EC2HardwareBuilder("cc1.4xlarge").cc1().ram(23552).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 4.0), (Object)new Processor(4.0, 4.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder cc2_8xlarge() {
        return new EC2HardwareBuilder("cc2.8xlarge").cc2().ram(61952).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 5.5), (Object)new Processor(8.0, 5.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder g2_2xlarge() {
        return new EC2HardwareBuilder("g2.2xlarge").g2().ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(60.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_xlarge() {
        return new EC2HardwareBuilder("i2.xlarge").i2().ram(31232).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_2xlarge() {
        return new EC2HardwareBuilder("i2.2xlarge").i2().ram(62464).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.375))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_4xlarge() {
        return new EC2HardwareBuilder("i2.4xlarge").i2().ram(124928).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.3125))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_8xlarge() {
        return new EC2HardwareBuilder("i2.8xlarge").i2().ram(249856).processors((List<Processor>)ImmutableList.of((Object)new Processor(32.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sde").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdf").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdg").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdh").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdi").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder hi1_4xlarge() {
        return new EC2HardwareBuilder("hi1.4xlarge").hi1().ram(61952).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.1875))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1024.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1024.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder hs1_8xlarge() {
        float twoTB = 2097152.0f;
        ImmutableList.Builder all24Volumes = ImmutableList.builder();
        all24Volumes.add((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(twoTB)).device("/dev/sda1").bootDevice(true).durable(false).build());
        UnmodifiableIterator unmodifiableIterator = ImmutableSet.of((Object)Character.valueOf('b'), (Object)Character.valueOf('c'), (Object)Character.valueOf('d'), (Object)Character.valueOf('e'), (Object)Character.valueOf('f'), (Object)Character.valueOf('g'), (Object[])new Character[]{Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x')}).iterator();
        while (unmodifiableIterator.hasNext()) {
            char letter = ((Character)unmodifiableIterator.next()).charValue();
            all24Volumes.add((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(twoTB)).device("/dev/sd" + letter).bootDevice(false).durable(false).build());
        }
        return new EC2HardwareBuilder("hs1.8xlarge").hs1().ram(119808).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.1875))).volumes((List<Volume>)all24Volumes.build()).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder r3_large() {
        return new EC2HardwareBuilder("r3.large").r3().ram(15616).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(32.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder r3_xlarge() {
        return new EC2HardwareBuilder("r3.xlarge").r3().ram(31232).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder r3_2xlarge() {
        return new EC2HardwareBuilder("r3.2xlarge").r3().ram(62464).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(160.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder r3_4xlarge() {
        return new EC2HardwareBuilder("r3.4xlarge").r3().ram(124928).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder r3_8xlarge() {
        return new EC2HardwareBuilder("r3.8xlarge").r3().ram(249856).processors((List<Processor>)ImmutableList.of((Object)new Processor(32.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder r4_large() {
        return new EC2HardwareBuilder("r4.large").r4().ram(15616).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.3)));
    }

    public static EC2HardwareBuilder r4_xlarge() {
        return new EC2HardwareBuilder("r4.xlarge").r4().ram(31232).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.3)));
    }

    public static EC2HardwareBuilder r4_2xlarge() {
        return new EC2HardwareBuilder("r4.2xlarge").r4().ram(62464).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.3)));
    }

    public static EC2HardwareBuilder r4_4xlarge() {
        return new EC2HardwareBuilder("r4.4xlarge").r4().ram(124928).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.3)));
    }

    public static EC2HardwareBuilder r4_8xlarge() {
        return new EC2HardwareBuilder("r4.8xlarge").r4().ram(249856).processors((List<Processor>)ImmutableList.of((Object)new Processor(32.0, 2.3)));
    }

    public static EC2HardwareBuilder r4_16xlarge() {
        return new EC2HardwareBuilder("r4.16xlarge").r4().ram(499712).processors((List<Processor>)ImmutableList.of((Object)new Processor(64.0, 2.3)));
    }

    public static EC2HardwareBuilder x1_16xlarge() {
        return new EC2HardwareBuilder("x1.16xlarge").x1().ram(999424).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1920.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).processors((List<Processor>)ImmutableList.of((Object)new Processor(64.0, 2.3)));
    }

    public static EC2HardwareBuilder x1_32xlarge() {
        return new EC2HardwareBuilder("x1.32xlarge").x1().ram(1998848).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1920.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1920.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).processors((List<Processor>)ImmutableList.of((Object)new Processor(128.0, 2.3)));
    }

    public Hardware build() {
        Preconditions.checkNotNull(this.virtualizationType, (Object)"virtualizationType");
        boolean reset = false;
        if (this.supportsImage == null) {
            reset = true;
        }
        try {
            this.supportsImage = Predicates.and((Predicate[])new Predicate[]{this.rootDeviceType, this.virtualizationType, this.imageIds, this.is64Bit});
            Hardware hardware = super.build();
            return hardware;
        }
        finally {
            if (reset) {
                this.supportsImage = null;
            }
        }
    }

    public static class RequiresVirtualizationType
    implements Predicate<Image> {
        final VirtualizationType type;

        public RequiresVirtualizationType(VirtualizationType type) {
            this.type = (VirtualizationType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type must be defined"));
        }

        public boolean apply(Image image) {
            return image.getOperatingSystem() != null && image.getOperatingSystem().getArch() != null && this.type == VirtualizationType.fromValue(image.getOperatingSystem().getArch());
        }

        public String toString() {
            return "requiresVirtualizationType(" + (Object)((Object)this.type) + ")";
        }
    }

    public static class RequiresRootDeviceType
    implements Predicate<Image> {
        final RootDeviceType type;

        public RequiresRootDeviceType(RootDeviceType type) {
            this.type = (RootDeviceType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type must be defined"));
        }

        public boolean apply(Image image) {
            return image.getUserMetadata().containsKey("rootDeviceType") && this.type == RootDeviceType.fromValue((String)image.getUserMetadata().get("rootDeviceType"));
        }

        public String toString() {
            return "requiresRootDeviceType(" + (Object)((Object)this.type) + ")";
        }
    }
}

