/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.logging.Logger;

public class RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap
implements Callable<ExecResponse> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final RunScriptOnNode runScriptOnNode;
    private final Map<NodeMetadata, Exception> badNodes;
    private final Map<NodeMetadata, ExecResponse> goodNodes;
    private transient boolean tainted;

    @AssistedInject
    public RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap(RunScriptOnNode runScriptOnNode, Map<NodeMetadata, ExecResponse> goodNodes, Map<NodeMetadata, Exception> badNodes) {
        this.runScriptOnNode = (RunScriptOnNode)Preconditions.checkNotNull((Object)runScriptOnNode, (Object)"runScriptOnNode");
        this.badNodes = (Map)Preconditions.checkNotNull(badNodes, (Object)"badNodes");
        this.goodNodes = (Map)Preconditions.checkNotNull(goodNodes, (Object)"goodNodes");
    }

    @Override
    public ExecResponse call() {
        Preconditions.checkState((this.runScriptOnNode != null ? 1 : 0) != 0, (Object)"runScriptOnNode must be set");
        Preconditions.checkState((!this.tainted ? 1 : 0) != 0, (String)"this object is not designed to be reused: %s", (Object[])new Object[]{this.toString()});
        this.tainted = true;
        try {
            ExecResponse exec = this.runScriptOnNode.call();
            this.logger.debug("<< options applied node(%s)", new Object[]{this.runScriptOnNode.getNode().getId()});
            this.logger.trace("<< script output for node(%s): %s", new Object[]{this.runScriptOnNode.getNode().getId(), exec});
            this.goodNodes.put(this.runScriptOnNode.getNode(), exec);
            return exec;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "<< problem applying options to node(%s): ", new Object[]{this.runScriptOnNode.getNode().getId(), Throwables.getRootCause((Throwable)e).getMessage()});
            this.badNodes.put(this.runScriptOnNode.getNode(), e);
            return null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("runScriptOnNode", (Object)this.runScriptOnNode).add("goodNodes", this.goodNodes).add("badNodes", this.badNodes).toString();
    }
}

