/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.apache.brooklyn.util.stream.Streams;

public class Serializers {
    public static <T> T reconstitute(T object) throws IOException, ClassNotFoundException {
        return Serializers.reconstitute(object, ObjectReplacer.NOOP);
    }

    public static <T> T reconstitute(T object, ObjectReplacer replacer) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        return Serializers.reconstitute(object, object.getClass().getClassLoader(), replacer);
    }

    public static <T> T reconstitute(T object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return Serializers.reconstitute(object, classLoader, ObjectReplacer.NOOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T reconstitute(T object, ClassLoader classLoader, ObjectReplacer replacer) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class ReconstitutingObjectOutputStream
        extends ObjectOutputStream {
            final /* synthetic */ ObjectReplacer val$replacer;

            public ReconstitutingObjectOutputStream(OutputStream outputStream2) throws IOException {
                this.val$replacer = outputStream2;
                super(outputStream);
                this.enableReplaceObject(true);
            }

            @Override
            protected Object replaceObject(Object obj) throws IOException {
                return this.val$replacer.replace(obj);
            }
        }
        ReconstitutingObjectOutputStream oos = new ReconstitutingObjectOutputStream((OutputStream)baos, replacer);
        oos.writeObject(object);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        class ReconstitutingObjectInputStream
        extends ClassLoaderObjectInputStream {
            final /* synthetic */ ObjectReplacer val$replacer;

            public ReconstitutingObjectInputStream(InputStream classLoader, ClassLoader classLoader2) throws IOException {
                this.val$replacer = classLoader2;
                super(inputStream, (ClassLoader)((Object)classLoader));
                super.enableResolveObject(true);
            }

            @Override
            protected Object resolveObject(Object obj) throws IOException {
                return this.val$replacer.resolve(obj);
            }
        }
        ReconstitutingObjectInputStream ois = new ReconstitutingObjectInputStream((InputStream)bais, classLoader, replacer);
        try {
            Object object2 = ois.readObject();
            return (T)object2;
        }
        finally {
            Streams.closeQuietly(ois);
        }
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ClassLoaderObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class<?> clazz = Class.forName(objectStreamClass.getName(), false, this.classLoader);
            if (clazz != null) {
                return clazz;
            }
            return super.resolveClass(objectStreamClass);
        }
    }

    public static interface ObjectReplacer {
        public static final ObjectReplacer NOOP = new ObjectReplacer(){

            @Override
            public Object replace(Object toserialize) {
                return toserialize;
            }

            @Override
            public Object resolve(Object todeserialize) {
                return todeserialize;
            }
        };

        public Object replace(Object var1);

        public Object resolve(Object var1);
    }
}

