/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.appmodel.HasBlueprintWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.flow.ForeachWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.variables.SetVariableWorkflowStep;
import org.apache.brooklyn.core.workflow.store.WorkflowStatePersistenceViaSensors;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChildrenWorkflowStep
extends WorkflowStepDefinition
implements HasBlueprintWorkflowStep,
WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChildrenWorkflowStep.class);
    public static final String SHORTHAND = "[ \" of \" ${parent} ] [ \" type \" ${type} ] [ \" id \" ${identifier_expression} ] [ \" from \" ${items} ]";
    public static final ConfigKey<Object> PARENT = ConfigKeys.newConfigKey(Object.class, "parent", "the entity or entity ID whose children are to be updated, defaulting to the current entity; any children which do not match something in `items` may be removed");
    public static final ConfigKey<String> IDENTIFIER_EXRPESSION = ConfigKeys.newStringConfigKey("identifier_expression", "an expression in terms of a local variable `item` to use to identify the same child; e.g. if the `items` is of the form `[{ field_id: 1, name: \"Ticket 1\" },...]` then `identifier_expression: ticket_${item.field_id}` will create/update/delete a child whose ID is `ticket_1`; ignored unless `item_check_workflow` is specified");
    public static final ConfigKey<List> ITEMS = ConfigKeys.newConfigKey(List.class, "items", "the list of items to be used to create/update/delete the children");
    public static final ConfigKey<CustomWorkflowStep> MATCH_CHECK_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, "match_check").build();
    public static final ConfigKey<CustomWorkflowStep> CREATION_CHECK_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, "creation_check").build();
    public static final ConfigKey<CustomWorkflowStep> DELETION_CHECK_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, "deletion_check").build();
    public static final ConfigKey<CustomWorkflowStep> ON_CREATE_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, "on_create").build();
    public static final ConfigKey<CustomWorkflowStep> ON_UPDATE_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, "on_update").build();
    public static final ConfigKey<CustomWorkflowStep> ON_DELETE_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, "on_delete").build();
    protected Object lock;
    protected Object concurrency;

    @Override
    public Logger logger() {
        return LOG;
    }

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        this.validateStepBlueprint(mgmt, workflow);
    }

    @Override
    public WorkflowStepDefinition.SubWorkflowsForReplay getSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, boolean forced, boolean peekingOnly, boolean allowInternallyEvenIfDisabled) {
        WorkflowStepDefinition.SubWorkflowsForReplay result;
        WorkflowExecutionContext resultW = this.getSubWorkflowForReplay(context, forced, peekingOnly, allowInternallyEvenIfDisabled);
        if (resultW == null) {
            result = new WorkflowStepDefinition.SubWorkflowsForReplay();
            result.isResumableOnlyAtParent = true;
        } else {
            result = WorkflowReplayUtils.getSubWorkflowsForReplay(context, forced, peekingOnly, allowInternallyEvenIfDisabled, sw -> {
                sw.isResumableOnlyAtParent = true;
            });
            result.subworkflows = MutableList.of((Object)resultW);
        }
        return result;
    }

    protected WorkflowExecutionContext getSubWorkflowForReplay(WorkflowStepInstanceExecutionContext context, boolean forced, boolean peekingOnly, boolean allowInternallyEvenIfDisabled) {
        UpdateChildrenStepState stepState = this.getStepState(context);
        if (stepState.matchCheck != null && stepState.matchCheck.workflowTag != null) {
            return this.retrieveSubWorkflow(context, stepState.matchCheck.workflowTag.getWorkflowId());
        }
        if (stepState.creationCheck != null && stepState.creationCheck.workflowTag != null) {
            return this.retrieveSubWorkflow(context, stepState.creationCheck.workflowTag.getWorkflowId());
        }
        if (stepState.onCreate != null && stepState.onCreate.workflowTag != null) {
            return this.retrieveSubWorkflow(context, stepState.onCreate.workflowTag.getWorkflowId());
        }
        if (stepState.onUpdate != null && stepState.onUpdate.workflowTag != null) {
            return this.retrieveSubWorkflow(context, stepState.onUpdate.workflowTag.getWorkflowId());
        }
        if (stepState.deletionCheck != null && stepState.deletionCheck.workflowTag != null) {
            return this.retrieveSubWorkflow(context, stepState.deletionCheck.workflowTag.getWorkflowId());
        }
        if (stepState.onDelete != null && stepState.onDelete.workflowTag != null) {
            return this.retrieveSubWorkflow(context, stepState.onDelete.workflowTag.getWorkflowId());
        }
        return null;
    }

    private WorkflowExecutionContext retrieveSubWorkflow(WorkflowStepInstanceExecutionContext context, String workflowId) {
        return new WorkflowStatePersistenceViaSensors(context.getManagementContext()).getWorkflows(context.getEntity()).get(workflowId);
    }

    @Override
    public Object doTaskBodyWithSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, @Nonnull List<WorkflowExecutionContext> subworkflows, WorkflowStepDefinition.ReplayContinuationInstructions instructions) {
        WorkflowReplayUtils.markSubWorkflowsSupersededByTask(context, Tasks.current().getId());
        return this.doTaskBodyPossiblyResuming(context, instructions, subworkflows.isEmpty() ? null : (WorkflowExecutionContext)Iterables.getOnlyElement(subworkflows));
    }

    @Override
    protected UpdateChildrenStepState getStepState(WorkflowStepInstanceExecutionContext context) {
        return (UpdateChildrenStepState)super.getStepState(context);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, UpdateChildrenStepState stepState) {
        context.setStepState(stepState, true);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        return this.doTaskBodyPossiblyResuming(context, null, null);
    }

    protected Object doTaskBodyPossiblyResuming(WorkflowStepInstanceExecutionContext context, WorkflowStepDefinition.ReplayContinuationInstructions instructionsForResuming, WorkflowExecutionContext subworkflowTargetForResuming) {
        UpdateChildrenStepState stepState;
        ManagementContext mgmt = context.getManagementContext();
        UpdateChildrenStepState stepStateO = this.getStepState(context);
        if (stepStateO == null) {
            stepState = new UpdateChildrenStepState();
            Object parentId = context.getInput(PARENT);
            stepState.parent = parentId != null ? (Entity)WorkflowStepResolution.findEntity(context, parentId).get() : context.getEntity();
            stepState.identifier_expression = TypeCoercions.coerce(context.getInputRaw(IDENTIFIER_EXRPESSION.getName()), String.class);
            stepState.items = context.getInput(ITEMS);
            if (stepState.items == null) {
                throw new IllegalStateException("Items cannot be null");
            }
            this.setStepState(context, stepState);
        } else {
            stepState = stepStateO;
        }
        Object blueprintNotYetInterpolated = this.resolveBlueprint(context, () -> {
            String type = (String)context.getInput(TYPE);
            if (Strings.isBlank((CharSequence)type)) {
                throw new IllegalStateException("blueprint or type must be supplied");
            }
            return "type: " + StringEscapes.JavaStringEscapes.wrapJavaString((String)type);
        }, SetVariableWorkflowStep.InterpolationMode.DISABLED, TemplateProcessor.InterpolationErrorMode.FAIL);
        BiFunction<CustomWorkflowStep, Consumer, ConfigBag> outerWorkflowCustomers = (checkWorkflow, foreachCustom) -> {
            ForeachWorkflowStep foreach = new ForeachWorkflowStep((CustomWorkflowStep)checkWorkflow);
            foreach.getInput().put("parent", stepState.parent);
            foreach.getInput().put("identifier_expression", stepState.identifier_expression);
            foreach.getInput().put("blueprint", blueprintNotYetInterpolated);
            if (foreach.getIdempotent() == null) {
                foreach.setIdempotent(this.idempotent);
            }
            if (foreach.getConcurrency() == null) {
                foreach.setConcurrency(this.concurrency);
            }
            foreachCustom.accept(foreach);
            return ConfigBag.newInstance().configure(WorkflowCommonConfig.STEPS, MutableList.of((Object)foreach)).configure(WorkflowCommonConfig.IDEMPOTENT, this.idempotent);
        };
        List matches = this.runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(context, instructionsForResuming, subworkflowTargetForResuming, "Matching items against children", stepState.matchCheck, MATCH_CHECK_WORKFLOW, () -> new CustomWorkflowStep((List<Object>)MutableList.of((Object)"transform ${identifier_expression} | resolve_expression | set id", (Object)MutableMap.of((Object)"step", (Object)"fail message identifier_expression should be a non-static expression including an interpolated reference to item, instead got ${identifier_expression}", (Object)"condition", (Object)MutableMap.of((Object)"target", (Object)"${identifier_expression}", (Object)"equals", (Object)"${id}")), (Object[])new Object[]{"let child_or_id = ${parent.children[id]} ?? ${id}", "transform child_tostring = ${child_or_id} | to_string", "transform parent_tostring = ${parent} | to_string", "return ${child_or_id}"})), checkWorkflow -> (ConfigBag)outerWorkflowCustomers.apply((CustomWorkflowStep)checkWorkflow, foreach -> {
            foreach.setTarget(stepState.items);
            foreach.setTargetVarName("item");
        }), list -> list.stream().map(m -> m instanceof Entity ? new TransientEntityReference((Entity)m) : m).collect(Collectors.toList()));
        MutableList stringMatchesToCreate = MutableList.of();
        for (int i = 0; i < matches.size(); ++i) {
            Object m = matches.get(i);
            if (!(m instanceof String)) continue;
            stringMatchesToCreate.add(MutableMap.of((Object)"match", m, (Object)"item", stepState.items.get(i), (Object)"index", (Object)i));
        }
        List addedChildren = this.runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(context, instructionsForResuming, subworkflowTargetForResuming, "Creating new children (" + stringMatchesToCreate.size() + ")", stepState.creationCheck, CREATION_CHECK_WORKFLOW, () -> new CustomWorkflowStep((List<Object>)MutableList.of((Object)"transform blueprint_resolved = ${blueprint} | resolve_expression", (Object)MutableMap.of((Object)"step", (Object)"add-entity", (Object)"parent", (Object)"${parent}", (Object)"blueprint", (Object)"${blueprint_resolved}"), (Object[])new Object[]{"let result = ${output.entity}", MutableMap.of((Object)"step", (Object)"set-config", (Object)"config", (Object)MutableMap.of((Object)"entity", (Object)"${result}", (Object)"name", (Object)BrooklynConfigKeys.PLAN_ID.getName()), (Object)"value", (Object)"${match}"), "return ${result}"})), arg_0 -> UpdateChildrenWorkflowStep.lambda$doTaskBodyPossiblyResuming$10(outerWorkflowCustomers, (List)stringMatchesToCreate, arg_0), list -> list.stream().map(x -> MutableMap.copyOf((Map)((Map)x)).add((Object)"child", (Object)new TransientEntityReference((Entity)((Map)x).get("child")))).collect(Collectors.toList()));
        List onCreateTargets = addedChildren.stream().map(x -> MutableMap.copyOf((Map)x).add((Object)"child", (Object)((TransientEntityReference)x.get("child")).getEntity(mgmt))).collect(Collectors.toList());
        this.runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(context, instructionsForResuming, subworkflowTargetForResuming, "Calling on_create on newly created children (" + stringMatchesToCreate.size() + ")", stepState.onCreate, ON_CREATE_WORKFLOW, () -> new CustomWorkflowStep((List<Object>)MutableList.of((Object)MutableMap.of((Object)"step", (Object)"invoke-effector on_create", (Object)"entity", (Object)"${child}", (Object)"args", (Object)MutableMap.of((Object)"item", (Object)"${item}"), (Object)"condition", (Object)MutableMap.of((Object)"target", (Object)"${child.effector.on_create}")))), checkWorkflow -> (ConfigBag)outerWorkflowCustomers.apply((CustomWorkflowStep)checkWorkflow, foreach -> {
            foreach.setTarget(onCreateTargets);
            foreach.setTargetVarName("{child,item,index}");
        }), list -> list.size());
        MutableList onUpdateTargets = MutableList.copyOf(onCreateTargets);
        for (int i = 0; i < matches.size(); ++i) {
            Object m = matches.get(i);
            if (m instanceof TransientEntityReference) {
                m = ((TransientEntityReference)m).getEntity(mgmt);
            }
            if (!(m instanceof Entity)) continue;
            onUpdateTargets.add(MutableMap.of((Object)"child", m, (Object)"item", stepState.items.get(i), (Object)"index", (Object)i));
        }
        this.runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(context, instructionsForResuming, subworkflowTargetForResuming, "Calling on_update on item-matched children (" + onUpdateTargets.size() + ")", stepState.onUpdate, ON_UPDATE_WORKFLOW, () -> new CustomWorkflowStep((List<Object>)MutableList.of((Object)MutableMap.of((Object)"step", (Object)"invoke-effector on_update", (Object)"entity", (Object)"${child}", (Object)"args", (Object)MutableMap.of((Object)"item", (Object)"${item}"), (Object)"condition", (Object)MutableMap.of((Object)"target", (Object)"${child.effector.on_update}")))), arg_0 -> UpdateChildrenWorkflowStep.lambda$doTaskBodyPossiblyResuming$20(outerWorkflowCustomers, (List)onUpdateTargets, arg_0), list -> list.size());
        MutableMap oldChildren = MutableMap.of();
        stepState.parent.getChildren().forEach(arg_0 -> UpdateChildrenWorkflowStep.lambda$doTaskBodyPossiblyResuming$22((Map)oldChildren, arg_0));
        onUpdateTargets.forEach(arg_0 -> UpdateChildrenWorkflowStep.lambda$doTaskBodyPossiblyResuming$23((Map)oldChildren, arg_0));
        MutableList entitiesToPossiblyDelete = MutableList.copyOf(oldChildren.values());
        List deletionChecks = this.runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(context, instructionsForResuming, subworkflowTargetForResuming, "Checking old children (" + entitiesToPossiblyDelete.size() + ") for deletion", stepState.deletionCheck, DELETION_CHECK_WORKFLOW, () -> new CustomWorkflowStep((List<Object>)MutableList.of((Object)"return true")), arg_0 -> UpdateChildrenWorkflowStep.lambda$doTaskBodyPossiblyResuming$26(outerWorkflowCustomers, (List)entitiesToPossiblyDelete, arg_0), list -> list.stream().map(x -> {
            Object check = ((Map)x).get("delete");
            Entity child = (Entity)((Map)x).get("child");
            if ((check = TypeCoercions.coerce(check, Boolean.class)) == null) {
                throw new IllegalStateException("Invalid deletion check result for " + child + ": " + check);
            }
            if (!Boolean.TRUE.equals(check)) {
                return null;
            }
            return new TransientEntityReference(child);
        }).filter(x -> x != null).collect(Collectors.toList()));
        List onDeleteTargets = deletionChecks.stream().map(t -> t.getEntity(mgmt)).filter(x -> x != null).map(x -> MutableMap.of((Object)"child", (Object)x)).collect(Collectors.toList());
        this.runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(context, instructionsForResuming, subworkflowTargetForResuming, "Calling on_delete on children to delete (" + onDeleteTargets.size() + ")", stepState.onDelete, ON_DELETE_WORKFLOW, () -> new CustomWorkflowStep((List<Object>)MutableList.of((Object)MutableMap.of((Object)"step", (Object)"invoke-effector on_delete", (Object)"entity", (Object)"${child}", (Object)"condition", (Object)MutableMap.of((Object)"target", (Object)"${child.effector.on_delete}")))), checkWorkflow -> (ConfigBag)outerWorkflowCustomers.apply((CustomWorkflowStep)checkWorkflow, foreach -> {
            foreach.setTarget(onDeleteTargets);
            foreach.setTargetVarName("{child}");
        }), list -> list.size());
        for (TransientEntityReference entityToDelete : deletionChecks) {
            Entity entity = entityToDelete.getEntity(mgmt);
            if (entity == null || !Entities.isManagedActiveOrComingUp(entity)) continue;
            Entities.unmanage(entity);
        }
        return context.getPreviousStepOutput();
    }

    protected <T> T runOrResumeSubWorkflowForPhaseOrReturnPreviousIfCompleted(WorkflowStepInstanceExecutionContext context, WorkflowStepDefinition.ReplayContinuationInstructions instructionsForResuming, WorkflowExecutionContext subworkflowTargetForResuming, String name, WorkflowTagWithResult<T> stepSubState, ConfigKey<CustomWorkflowStep> key, Supplier<CustomWorkflowStep> defaultWorkflow, Function<CustomWorkflowStep, ConfigBag> outerWorkflowConfigFn, Function<List, T> postprocess) {
        if (stepSubState.result == null) {
            ManagementContext mgmt = context.getManagementContext();
            UpdateChildrenStepState stepState = this.getStepState(context);
            if (stepSubState.workflowTag == null) {
                CustomWorkflowStep checkWorkflow = (CustomWorkflowStep)context.getWorkflowExectionContext().resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, context.getInputRaw(key.getName()), TypeToken.of(CustomWorkflowStep.class));
                if (checkWorkflow == null) {
                    checkWorkflow = defaultWorkflow.get();
                }
                ConfigBag outerWorkflowConfig = outerWorkflowConfigFn.apply(checkWorkflow);
                WorkflowExecutionContext matchWorkflow = WorkflowExecutionContext.newInstanceUnpersistedWithParent((BrooklynObject)context.getEntity(), context.getWorkflowExectionContext(), WorkflowExecutionContext.WorkflowContextType.NESTED_WORKFLOW, name, outerWorkflowConfig, null, null, null);
                stepSubState.workflowTag = BrooklynTaskTags.tagForWorkflow(matchWorkflow);
                WorkflowReplayUtils.addNewSubWorkflow(context, stepSubState.workflowTag);
                this.setStepState(context, stepState);
                stepSubState.result = postprocess.apply((List)((Task)DynamicTasks.queue((TaskAdaptable)matchWorkflow.getTask(true).get())).getUnchecked());
            } else {
                stepSubState.result = postprocess.apply((List)WorkflowReplayUtils.replayResumingInSubWorkflow("workflow effector", context, subworkflowTargetForResuming, instructionsForResuming, (w, e) -> {
                    throw Exceptions.propagate((Throwable)e);
                }, true));
            }
            stepSubState.workflowTag = null;
            this.setStepState(context, stepState);
        }
        return stepSubState.result;
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    private static /* synthetic */ ConfigBag lambda$doTaskBodyPossiblyResuming$26(BiFunction outerWorkflowCustomers, List entitiesToPossiblyDelete, CustomWorkflowStep checkWorkflow) {
        return (ConfigBag)outerWorkflowCustomers.apply(checkWorkflow, foreach -> {
            foreach.setTarget(entitiesToPossiblyDelete);
            foreach.setTargetVarName("child");
            foreach.setWorkflowOutput(MutableMap.of((Object)"delete", (Object)"${output}", (Object)"child", (Object)"${child}"));
        });
    }

    private static /* synthetic */ void lambda$doTaskBodyPossiblyResuming$23(Map oldChildren, Map c) {
        Entity cfr_ignored_0 = (Entity)oldChildren.remove(((Entity)c.get("child")).getId());
    }

    private static /* synthetic */ void lambda$doTaskBodyPossiblyResuming$22(Map oldChildren, Entity c) {
        oldChildren.put(c.getId(), c);
    }

    private static /* synthetic */ ConfigBag lambda$doTaskBodyPossiblyResuming$20(BiFunction outerWorkflowCustomers, List onUpdateTargets, CustomWorkflowStep checkWorkflow) {
        return (ConfigBag)outerWorkflowCustomers.apply(checkWorkflow, foreach -> {
            foreach.setTarget(onUpdateTargets);
            foreach.setTargetVarName("{child,item,index}");
        });
    }

    private static /* synthetic */ ConfigBag lambda$doTaskBodyPossiblyResuming$10(BiFunction outerWorkflowCustomers, List stringMatchesToCreate, CustomWorkflowStep checkWorkflow) {
        return (ConfigBag)outerWorkflowCustomers.apply(checkWorkflow, foreach -> {
            foreach.setTarget(stringMatchesToCreate);
            foreach.setTargetVarName("{match,item,index}");
            foreach.setWorkflowOutput(MutableMap.of((Object)"index", (Object)"${index}", (Object)"match", (Object)"${match}", (Object)"child", (Object)"${output}", (Object)"item", (Object)"${item}"));
        });
    }

    static class TransientEntityReference {
        transient Entity entity;
        String entityId;

        public TransientEntityReference(Entity entity) {
            this.entity = entity;
            this.entityId = entity == null ? null : entity.getId();
        }

        public Entity getEntity(ManagementContext mgmt) {
            if (this.entityId == null) {
                return null;
            }
            if (this.entity != null && Entities.isManagedActiveOrComingUp(this.entity)) {
                return this.entity;
            }
            this.entity = (Entity)mgmt.lookup(this.entityId, Entity.class);
            if (this.entity != null && Entities.isManagedActiveOrComingUp(this.entity)) {
                return this.entity;
            }
            return null;
        }
    }

    static class WorkflowTagWithResult<T> {
        BrooklynTaskTags.WorkflowTaskTag workflowTag;
        T result;

        WorkflowTagWithResult() {
        }
    }

    static class UpdateChildrenStepState {
        Entity parent;
        String identifier_expression;
        List items;
        WorkflowTagWithResult<List> matchCheck = new WorkflowTagWithResult();
        WorkflowTagWithResult<List<Map>> creationCheck = new WorkflowTagWithResult();
        WorkflowTagWithResult<Object> onCreate = new WorkflowTagWithResult();
        WorkflowTagWithResult<Object> onUpdate = new WorkflowTagWithResult();
        WorkflowTagWithResult<List> deletionCheck = new WorkflowTagWithResult();
        WorkflowTagWithResult<Object> onDelete = new WorkflowTagWithResult();

        UpdateChildrenStepState() {
        }
    }
}

