/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.entity.group.RemovalStrategy;

public class SensorMatchingRemovalStrategy<T>
extends RemovalStrategy {
    public static final ConfigKey<AttributeSensor> SENSOR = ConfigKeys.newConfigKey(AttributeSensor.class, "sensor.matching.sensor");
    public static final ConfigKey<Object> DESIRED_VALUE = ConfigKeys.newConfigKey(Object.class, "sensor.matching.value");

    @Nullable
    public Entity apply(@Nullable Collection<Entity> input) {
        AttributeSensor sensor = (AttributeSensor)this.config().get(SENSOR);
        Object desiredValue = this.config().get(DESIRED_VALUE);
        for (Entity entity : input) {
            if (!Objects.equals(desiredValue, entity.sensors().get(sensor))) continue;
            return entity;
        }
        return null;
    }
}

