/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.module.api.internal;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.UiModuleAction;
import org.apache.brooklyn.ui.modularity.module.api.internal.UiModuleActionImpl;

public class UiModuleImpl
implements UiModule {
    private String id;
    private String name;
    private String slug;
    private String description;
    private String icon;
    private Set<String> types = new LinkedHashSet<String>();
    private Set<String> supersedesBundles = new LinkedHashSet<String>();
    private boolean stopExisting = true;
    private String path;
    private List<UiModuleAction> actions = new ArrayList<UiModuleAction>();
    private int order;

    public static UiModuleImpl copyOf(UiModule src) {
        UiModuleImpl result = new UiModuleImpl();
        result.setId(src.getId());
        result.setName(src.getName());
        result.setOrder(src.getOrder());
        result.setSlug(src.getSlug());
        result.setDescription(src.getDescription());
        result.setIcon(src.getIcon());
        if (src.getTypes() != null) {
            result.types.addAll(src.getTypes());
        }
        if (src.getSupersedesBundles() != null) {
            result.supersedesBundles.addAll(src.getSupersedesBundles());
        }
        result.setStopExisting(src.getStopExisting());
        result.setPath(src.getPath());
        if (src.getActions() != null) {
            result.actions.addAll(src.getActions());
        }
        return result;
    }

    public static UiModuleImpl createFromMap(Map<String, ?> incomingMap) {
        Object actions;
        Object supersedes;
        UiModuleImpl result = new UiModuleImpl();
        result.setId((String)Optional.fromNullable((Object)((String)incomingMap.get("id"))).or((Object)UUID.randomUUID().toString()));
        result.setName((String)Optional.fromNullable((Object)((String)incomingMap.get("name"))).or((Object)result.getId()));
        result.setOrder((Integer)Optional.fromNullable((Object)((Integer)incomingMap.get("order"))).or((Object)10000));
        result.setSlug((String)incomingMap.get("slug"));
        result.setDescription((String)incomingMap.get("description"));
        result.setIcon((String)Optional.fromNullable((Object)((String)incomingMap.get("icon"))).or((Object)"fa-cogs"));
        Object types = incomingMap.get("types");
        if (types != null && types instanceof List) {
            List typesTyped = (List)types;
            result.setTypes(new LinkedHashSet<String>(typesTyped));
        }
        if ((supersedes = incomingMap.get("supersedes")) != null && supersedes instanceof List) {
            List supersedesTyped = (List)supersedes;
            result.setSupersedesBundles(new LinkedHashSet<String>(supersedesTyped));
        }
        if (incomingMap.containsKey("stopExisting")) {
            result.setStopExisting(Boolean.getBoolean((String)incomingMap.get("stopExisting")));
        }
        if ((actions = incomingMap.get("actions")) != null && actions instanceof List) {
            for (Object action : (List)actions) {
                Map actionTyped = (Map)action;
                result.action(UiModuleActionImpl.createFromMap(actionTyped));
            }
        }
        return result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getTypes() {
        return this.types;
    }

    @Override
    public Set<String> getSupersedesBundles() {
        return this.supersedesBundles;
    }

    @Override
    public boolean getStopExisting() {
        return this.stopExisting;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<UiModuleAction> getActions() {
        return this.actions;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTypes(Set<String> types) {
        this.types = types;
    }

    public void setSupersedesBundles(Set<String> supersedesBundles) {
        this.supersedesBundles = supersedesBundles;
    }

    public void setStopExisting(boolean stopExisting) {
        this.stopExisting = stopExisting;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setActions(List<UiModuleAction> actions) {
        this.actions = actions;
    }

    public UiModuleImpl id(String id) {
        this.id = id;
        return this;
    }

    public UiModuleImpl icon(String icon) {
        this.icon = icon;
        return this;
    }

    public UiModuleImpl name(String name) {
        this.name = name;
        return this;
    }

    public UiModuleImpl slug(String slug) {
        this.slug = slug;
        return this;
    }

    public UiModuleImpl description(String description) {
        this.description = description;
        return this;
    }

    public UiModuleImpl types(Set<String> types) {
        this.types = types;
        return this;
    }

    public UiModuleImpl path(String path) {
        this.path = path;
        return this;
    }

    public UiModuleImpl action(UiModuleAction action) {
        this.actions.add(action);
        return this;
    }

    public UiModuleImpl order(int order) {
        this.order = order;
        return this;
    }
}

