/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.features.SnapshotApi;
import org.jclouds.util.Predicates2;

public class SnapshotPredicates {
    public static Predicate<Snapshot> awaitAvailable(SnapshotApi snapshotApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(snapshotApi, Volume.Status.AVAILABLE);
        return Predicates2.retry((Predicate)statusPredicate, (long)1200L, (long)5L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static Predicate<Snapshot> awaitDeleted(SnapshotApi snapshotApi) {
        DeletedPredicate deletedPredicate = new DeletedPredicate(snapshotApi);
        return Predicates2.retry((Predicate)deletedPredicate, (long)1200L, (long)5L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static Predicate<Snapshot> awaitStatus(SnapshotApi snapshotApi, Volume.Status status, long maxWaitInSec, long periodInSec) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(snapshotApi, status);
        return Predicates2.retry((Predicate)statusPredicate, (long)maxWaitInSec, (long)periodInSec, (long)periodInSec, (TimeUnit)TimeUnit.SECONDS);
    }

    private static class DeletedPredicate
    implements Predicate<Snapshot> {
        private SnapshotApi snapshotApi;

        public DeletedPredicate(SnapshotApi snapshotApi) {
            this.snapshotApi = (SnapshotApi)Preconditions.checkNotNull((Object)snapshotApi, (Object)"snapshotApi must be defined");
        }

        public boolean apply(Snapshot snapshot) {
            Preconditions.checkNotNull((Object)snapshot, (Object)"snapshot must be defined");
            return this.snapshotApi.get(snapshot.getId()) == null;
        }
    }

    private static class StatusUpdatedPredicate
    implements Predicate<Snapshot> {
        private SnapshotApi snapshotApi;
        private Volume.Status status;

        public StatusUpdatedPredicate(SnapshotApi snapshotApi, Volume.Status status) {
            this.snapshotApi = (SnapshotApi)Preconditions.checkNotNull((Object)snapshotApi, (Object)"snapshotApi must be defined");
            this.status = (Volume.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must be defined"));
        }

        public boolean apply(Snapshot snapshot) {
            Preconditions.checkNotNull((Object)snapshot, (Object)"snapshot must be defined");
            if (this.status.equals((Object)snapshot.getStatus())) {
                return true;
            }
            Snapshot snapshotUpdated = this.snapshotApi.get(snapshot.getId());
            Preconditions.checkNotNull((Object)snapshotUpdated, (String)"Snapshot %s not found.", (Object)snapshot.getId());
            return this.status.equals((Object)snapshotUpdated.getStatus());
        }
    }
}

