/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseSyncGatewayImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=CouchbaseSyncGatewayImpl.class)
public interface CouchbaseSyncGateway
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.0-beta3.1");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://packages.couchbase.com/releases/couchbase-sync-gateway/1.0-beta/couchbase-sync-gateway-community_${version}_${driver.osTag}");
    @SetFromFlag(value="couchbaseServer")
    public static final ConfigKey<Entity> COUCHBASE_SERVER = ConfigKeys.newConfigKey(Entity.class, (String)"couchbaseSyncGateway.couchbaseNode", (String)"Couchbase server node or cluster the sync gateway connects to");
    @SetFromFlag(value="serverPool")
    public static final ConfigKey<String> COUCHBASE_SERVER_POOL = ConfigKeys.newStringConfigKey((String)"couchbaseSyncGateway.serverPool", (String)"Couchbase Server pool name in which to find buckets", (String)"default");
    @SetFromFlag(value="couchbaseServerBucket")
    public static final ConfigKey<String> COUCHBASE_SERVER_BUCKET = ConfigKeys.newStringConfigKey((String)"couchbaseSyncGateway.serverBucket", (String)"Name of the Couchbase bucket to use", (String)"sync_gateway");
    @SetFromFlag(value="pretty")
    public static final ConfigKey<Boolean> PRETTY = ConfigKeys.newBooleanConfigKey((String)"couchbaseSyncGateway.pretty", (String)"Pretty-print JSON responses. This is useful for debugging, but reduces performance.", (Boolean)false);
    @SetFromFlag(value="verbose")
    public static final ConfigKey<Boolean> VERBOSE = ConfigKeys.newBooleanConfigKey((String)"couchbaseSyncGateway.verbose", (String)"Logs more information about requests.", (Boolean)false);
    public static final AttributeSensor<String> COUCHBASE_SERVER_WEB_URL = Sensors.newStringSensor((String)"couchbaseSyncGateway.serverWebUrl", (String)"The Url and web port of the couchbase server to connect to");
    public static final AttributeSensor<String> MANAGEMENT_URL = Sensors.newStringSensor((String)"coucbaseSyncGateway.managementUrl", (String)"Management URL for Couchbase Sycn Gateway");
    public static final PortAttributeSensorAndConfigKey SYNC_REST_API_PORT = new PortAttributeSensorAndConfigKey("couchbaseSyncGateway.syncRestPort", "Port the Sync REST API listens on", (Object)"4984");
    public static final PortAttributeSensorAndConfigKey ADMIN_REST_API_PORT = new PortAttributeSensorAndConfigKey("couchbaseSyncGateway.adminRestPort", "Port the Admin REST API listens on", (Object)"4985");
}

