/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private InputStream in;
    private OutputStream out;
    private volatile boolean finish = false;
    private volatile boolean finished = false;
    private boolean closeWhenExhausted;
    private boolean nonBlocking;
    private boolean autoflush;
    private Throwable exception;
    private int bufferSize = 128;
    private boolean started;
    private Thread thread;

    public StreamPumper(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        this.in = in;
        this.out = out;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public StreamPumper(InputStream in, OutputStream out) {
        this(in, out, false);
    }

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.started = true;
            this.thread = Thread.currentThread();
        }
        byte[] buf = new byte[this.bufferSize];
        int length = 0;
        try {
            boolean finish;
            do {
                if (this.nonBlocking) {
                    while (this.in.available() > 0 && (length = this.in.read(buf)) > 0) {
                        this.out.write(buf, 0, length);
                        if (!this.autoflush) continue;
                        this.out.flush();
                    }
                    Thread.sleep(50L);
                } else {
                    do {
                        if ((length = this.in.read(buf)) <= 0) continue;
                        this.out.write(buf, 0, length);
                        if (!this.autoflush) continue;
                        this.out.flush();
                    } while (length > 0);
                }
                StreamPumper streamPumper2 = this;
                synchronized (streamPumper2) {
                    finish = this.finish || length < 0;
                }
            } while (!finish);
        }
        catch (Throwable t) {
            StreamPumper streamPumper3 = this;
            synchronized (streamPumper3) {
                this.exception = t;
            }
        }
        finally {
            try {
                this.out.flush();
            }
            catch (IOException finish) {}
            if (this.closeWhenExhausted) {
                try {
                    this.out.close();
                }
                catch (IOException finish) {}
            }
            StreamPumper finish = this;
            synchronized (finish) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        if (this.started) {
            throw new IllegalStateException("Cannot set buffer size on a running StreamPumper");
        }
        this.bufferSize = bufferSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    public synchronized void stop() {
        this.finish = true;
        if (this.nonBlocking && this.thread != null && !this.finished) {
            this.thread.interrupt();
        }
        this.notifyAll();
    }

    public InputStream getInputStream() {
        return this.in;
    }
}

