/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functionloader.filters;

import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.functionloader.FunctionLoader;
import org.jclouds.scriptbuilder.functionloader.FunctionNotFoundException;

public class LicenseHeaderFilter
implements FunctionLoader {
    private final FunctionLoader delegate;

    public LicenseHeaderFilter(FunctionLoader delegate) {
        this.delegate = (FunctionLoader)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    @Override
    public String loadFunction(String function, OsFamily family) throws FunctionNotFoundException {
        return this.filter(this.delegate.loadFunction(function, family), family);
    }

    public String filter(String lines, OsFamily family) {
        try {
            return (String)CharSource.wrap((CharSequence)((CharSequence)Preconditions.checkNotNull((Object)lines, (Object)"lines"))).readLines((LineProcessor)new LicenseHeaderProcessor((OsFamily)((Object)Preconditions.checkNotNull((Object)((Object)family), (Object)"family"))));
        }
        catch (IOException e) {
            return lines;
        }
    }

    private static class LicenseHeaderProcessor
    implements LineProcessor<String> {
        private static final String LICENSE_TOKEN_START = "Licensed to the Apache Software Foundation";
        private static final String LICENSE_TOKEN_END = "limitations under the License";
        private final StringBuilder builder = new StringBuilder();
        private final String commentToken;
        private final String lineTerminationToken;
        private boolean isLicenseComment;

        public LicenseHeaderProcessor(OsFamily family) {
            this.commentToken = ShellToken.REM.to(family);
            this.lineTerminationToken = ShellToken.LF.to(family);
            this.isLicenseComment = false;
        }

        public boolean processLine(String line) throws IOException {
            String trimmed = line.trim();
            boolean isComment = this.isCommentLine(trimmed);
            if (isComment && line.contains(LICENSE_TOKEN_START)) {
                this.isLicenseComment = true;
            }
            if (!this.isLicenseComment && !this.isEmptyCommentLine(trimmed)) {
                this.builder.append(line);
                this.builder.append(this.lineTerminationToken);
            }
            if (this.isLicenseComment && line.contains(LICENSE_TOKEN_END)) {
                this.isLicenseComment = false;
            }
            return true;
        }

        public String getResult() {
            return this.builder.toString();
        }

        private boolean isEmptyCommentLine(String line) {
            return line.equals(this.commentToken) || line.equals("REM");
        }

        private boolean isCommentLine(String line) {
            return line.startsWith(this.commentToken) || line.startsWith("REM");
        }
    }
}

