/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.loaders;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.internal.RegionAndName;
import org.jclouds.googlecomputeengine.domain.Subnetwork;

@Singleton
public class SubnetworkLoader
extends CacheLoader<RegionAndName, Optional<Subnetwork>> {
    private final GoogleComputeEngineApi api;

    @Inject
    SubnetworkLoader(GoogleComputeEngineApi api) {
        this.api = api;
    }

    public Optional<Subnetwork> load(RegionAndName key) throws ExecutionException {
        try {
            return Optional.fromNullable((Object)this.api.subnetworksInRegion(key.regionId()).get(key.name()));
        }
        catch (Exception ex) {
            throw new ExecutionException(SubnetworkLoader.message(key, ex), ex);
        }
    }

    public static String message(RegionAndName key, Exception ex) {
        return String.format("could not find subnet %s in region %s: %s", key.name(), key.regionId(), ex.getMessage());
    }
}

