/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.route53.binders.BindChangeBatch;
import org.jclouds.route53.binders.BindNextRecord;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.ChangeBatch;
import org.jclouds.route53.domain.ResourceRecordSet;
import org.jclouds.route53.domain.ResourceRecordSetIterable;
import org.jclouds.route53.filters.RestAuthentication;
import org.jclouds.route53.functions.ResourceRecordSetIterableToPagedIterable;
import org.jclouds.route53.functions.SerializeRRS;
import org.jclouds.route53.xml.ChangeHandler;
import org.jclouds.route53.xml.ListResourceRecordSetsResponseHandler;

@RequestFilters(value={RestAuthentication.class})
@VirtualHost
public interface ResourceRecordSetApi {
    @Named(value="ChangeResourceRecordSets")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/rrset")
    @Payload(value="<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><ChangeBatch><Changes><Change><Action>CREATE</Action>{rrs}</Change></Changes></ChangeBatch></ChangeResourceRecordSetsRequest>")
    @XMLResponseParser(value=ChangeHandler.class)
    public Change create(@PayloadParam(value="rrs") @ParamParser(value=SerializeRRS.class) ResourceRecordSet var1);

    @Named(value="ChangeResourceRecordSets")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/rrset")
    @XMLResponseParser(value=ChangeHandler.class)
    public Change apply(@BinderParam(value=BindChangeBatch.class) ChangeBatch var1);

    @Named(value="ListResourceRecordSets")
    @GET
    @Path(value="/rrset")
    @XMLResponseParser(value=ListResourceRecordSetsResponseHandler.class)
    @Transform(value=ResourceRecordSetIterableToPagedIterable.class)
    public PagedIterable<ResourceRecordSet> list();

    @Named(value="ListResourceRecordSets")
    @GET
    @Path(value="/rrset")
    @XMLResponseParser(value=ListResourceRecordSetsResponseHandler.class)
    public ResourceRecordSetIterable listFirstPage();

    @Named(value="ListResourceRecordSets")
    @GET
    @Path(value="/rrset")
    @XMLResponseParser(value=ListResourceRecordSetsResponseHandler.class)
    public ResourceRecordSetIterable listAt(@BinderParam(value=BindNextRecord.class) ResourceRecordSetIterable.NextRecord var1);

    @Named(value="ChangeResourceRecordSets")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/rrset")
    @Payload(value="<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><ChangeBatch><Changes><Change><Action>DELETE</Action>{rrs}</Change></Changes></ChangeBatch></ChangeResourceRecordSetsRequest>")
    @XMLResponseParser(value=ChangeHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Change delete(@PayloadParam(value="rrs") @ParamParser(value=SerializeRRS.class) ResourceRecordSet var1);
}

