/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.external.SshWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.variables.SetVariableWorkflowStep;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.location.winrm.WinRmTasks;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.ConnectionDefinition;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.Strings;

public class WinrmWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "[ \"to \" ${endpoint} ] ${command}";
    public static final ConfigKey<String> ENDPOINT = ConfigKeys.newStringConfigKey((String)"endpoint");
    public static final ConfigKey<String> COMMAND = ConfigKeys.newStringConfigKey((String)"command");
    public static final ConfigKey<Map<String, Object>> ENV = new MapConfigKey.Builder(Object.class, "env").build();
    public static final ConfigKey<DslPredicates.DslPredicate<Integer>> EXIT_CODE = ConfigKeys.newConfigKey((TypeToken)new TypeToken<DslPredicates.DslPredicate<Integer>>(){}, (String)"exit_code");
    public static final ConfigKey<Integer> OUTPUT_MAX_SIZE = ConfigKeys.newIntegerConfigKey((String)"output_max_size", (String)"Maximum size for stdout and stderr, or -1 for no limit", (Integer)100000);
    ConfigKey<SetVariableWorkflowStep.InterpolationMode> INTERPOLATION_MODE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SetVariableWorkflowStep.INTERPOLATION_MODE, (Object)SetVariableWorkflowStep.InterpolationMode.FULL);
    ConfigKey<TemplateProcessor.InterpolationErrorMode> INTERPOLATION_ERRORS = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SetVariableWorkflowStep.INTERPOLATION_ERRORS, (Object)TemplateProcessor.InterpolationErrorMode.IGNORE);

    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Map env;
        RemoteExecTaskConfigHelper.RemoteExecCapabilityFromDefinition remoteExecCapability;
        String command = (String)new SetVariableWorkflowStep.ConfigurableInterpolationEvaluation(context, TypeToken.of(String.class), this.getInput().get(COMMAND.getName()), (SetVariableWorkflowStep.InterpolationMode)context.getInputOrDefault(this.INTERPOLATION_MODE), (TemplateProcessor.InterpolationErrorMode)context.getInputOrDefault(this.INTERPOLATION_ERRORS)).evaluate();
        if (Strings.isBlank((CharSequence)command)) {
            throw new IllegalStateException("'command' is required");
        }
        String endpoint = (String)context.getInput(ENDPOINT);
        if (Strings.isNonBlank((CharSequence)endpoint)) {
            throw new IllegalStateException("Explicit endpoint not currently supported for winrm step");
        }
        ConnectionDefinition cdef = (ConnectionDefinition)BrooklynTags.findSingleKeyMapValue((String)"connection", ConnectionDefinition.class, (Iterable)context.getEntity().tags().getTags());
        if (cdef != null) {
            remoteExecCapability = RemoteExecTaskConfigHelper.RemoteExecCapabilityFromDefinition.of((Entity)context.getEntity(), (ConnectionDefinition)cdef);
        } else {
            WinRmMachineLocation machine = (WinRmMachineLocation)((Object)Machines.findUniqueMachineLocation((Iterable)context.getEntity().getLocations(), WinRmMachineLocation.class).orThrow("No WinRm location available for workflow at " + context.getEntity() + " and no endpoint specified"));
            remoteExecCapability = new RemoteExecTaskConfigHelper.RemoteExecCapabilityFromLocation((MachineLocation)machine);
        }
        DslPredicates.DslPredicate exitcode = (DslPredicates.DslPredicate)context.getInput(EXIT_CODE);
        ProcessTaskFactory<Integer> tf = WinRmTasks.newWinrmExecTaskFactory((RemoteExecTaskConfigHelper.RemoteExecCapability)remoteExecCapability, command);
        if (exitcode != null) {
            tf.allowingNonZeroExitCode();
        }
        if ((env = (Map)context.getInput(ENV)) != null) {
            tf.environmentVariables(new ShellEnvironmentSerializer(context.getWorkflowExectionContext().getManagementContext()).serialize(env));
        }
        tf.returning(ptw -> {
            this.checkExitCode((ProcessTaskWrapper<?>)ptw, (DslPredicates.DslPredicate<Integer>)exitcode);
            return MutableMap.of((Object)"stdout", (Object)SshWorkflowStep.truncate((String)ptw.getStdout(), (Integer)((Integer)context.getInput(OUTPUT_MAX_SIZE))), (Object)"stderr", (Object)SshWorkflowStep.truncate((String)ptw.getStderr(), (Integer)((Integer)context.getInput(OUTPUT_MAX_SIZE))), (Object)"exit_code", (Object)ptw.getExitCode());
        });
        return ((ProcessTaskWrapper)DynamicTasks.queue((TaskAdaptable)tf.newTask())).asTask().getUnchecked();
    }

    protected Boolean isDefaultIdempotent() {
        return false;
    }

    protected void checkExitCode(ProcessTaskWrapper<?> ptw, DslPredicates.DslPredicate<Integer> exitcode) {
        Object implicit;
        if (exitcode == null) {
            return;
        }
        if (exitcode instanceof DslPredicates.DslPredicateBase && (implicit = ((DslPredicates.DslPredicateBase)exitcode).implicitEqualsUnwrapped()) != null && "any".equalsIgnoreCase("" + implicit)) {
            return;
        }
        if (!exitcode.apply((Object)ptw.getExitCode())) {
            throw new IllegalStateException("Invalid exit code '" + ptw.getExitCode() + "'");
        }
    }
}

