/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.repository;

import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.stream.MapStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class AggregateRepository
extends BaseRepository {
    private final List<Repository> repositories;

    public AggregateRepository(Collection<? extends Repository> repositories) {
        this.repositories = new ArrayList<Repository>(repositories);
    }

    public AggregateRepository(Repository ... repositories) {
        this.repositories = new ArrayList<Repository>();
        Collections.addAll(this.repositories, repositories);
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        Map<Requirement, Collection<Capability>> result = MapStream.of(this.repositories.stream().flatMap(repository -> repository.findProviders(requirements).entrySet().stream())).collect(MapStream.toMap(ResourceUtils::capabilitiesCombiner));
        return result;
    }

    public Collection<Capability> findProviders(Requirement req) {
        if (req == null) {
            return new ArrayList<Capability>();
        }
        Collection<Capability> capabilities = this.findProviders(Collections.singleton(req)).get(req);
        assert (capabilities != null) : "findProviders must return a map containing the collection";
        return capabilities;
    }
}

