/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.rest.api.ApplicationApi;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.api.SensorApi;
import org.apache.brooklyn.rest.domain.SensorSummary;
import org.apache.brooklyn.rest.util.EntityAttributesUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorTransformer {
    private static final Logger log = LoggerFactory.getLogger(SensorTransformer.class);

    public static SensorSummary sensorSummaryForCatalog(Sensor<?> sensor) {
        return new SensorSummary(sensor.getName(), sensor.getTypeName(), sensor.getDescription(), null);
    }

    public static SensorSummary sensorSummary(Entity entity, Sensor<?> sensor, UriBuilder ub) {
        URI applicationUri = WebResourceUtils.serviceUriBuilder(ub, ApplicationApi.class, "get").build(new Object[]{entity.getApplicationId()});
        URI entityUri = WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId()});
        URI selfUri = WebResourceUtils.serviceUriBuilder(ub, SensorApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId(), sensor.getName()});
        MutableMap.Builder lb = MutableMap.builder().put((Object)"self", (Object)selfUri).put((Object)"application", (Object)applicationUri).put((Object)"entity", (Object)entityUri).put((Object)"action:json", (Object)selfUri);
        if (sensor instanceof AttributeSensor) {
            Iterable hints = Iterables.filter((Iterable)RendererHints.getHintsFor((AttributeSensor)((AttributeSensor)sensor)), RendererHints.NamedAction.class);
            for (RendererHints.NamedAction na : hints) {
                SensorTransformer.addNamedAction((MutableMap.Builder<String, URI>)lb, na, entity, sensor);
            }
        }
        return new SensorSummary(sensor.getName(), sensor.getTypeName(), sensor.getDescription(), (Map)lb.build());
    }

    private static <T> void addNamedAction(MutableMap.Builder<String, URI> lb, RendererHints.NamedAction na, Entity entity, Sensor<T> sensor) {
        SensorTransformer.addNamedAction(lb, na, EntityAttributesUtils.tryGetAttribute(entity, (AttributeSensor)sensor), sensor, (BrooklynObject)entity);
    }

    static <T> void addNamedAction(MutableMap.Builder<String, URI> lb, RendererHints.NamedAction na, T value, Object contextKeyOrSensor, BrooklynObject contextObject) {
        if (na instanceof RendererHints.NamedActionWithUrl) {
            try {
                String v = ((RendererHints.NamedActionWithUrl)na).getUrlFromValue(value);
                if (Strings.isNonBlank((CharSequence)v)) {
                    String action = na.getActionName().toLowerCase();
                    lb.putIfAbsent((Object)("action:" + action), (Object)URI.create(v));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Unable to make action " + na + " from " + contextKeyOrSensor + " on " + contextObject + ": " + e, (Throwable)e);
            }
        }
    }
}

