/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.predicates.NodePredicates;

public class AllNodesInGroupTerminated
implements Predicate<ZoneAndName> {
    private final ComputeService computeService;

    @Inject
    public AllNodesInGroupTerminated(ComputeService computeService) {
        this.computeService = (ComputeService)Preconditions.checkNotNull((Object)computeService, (Object)"computeService");
    }

    public boolean apply(ZoneAndName input) {
        return Iterables.all((Iterable)this.computeService.listNodesDetailsMatching(Predicates.or((Predicate)NodePredicates.locationId((String)input.getZone()), (Predicate)NodePredicates.parentLocationId((String)input.getZone()))), (Predicate)Predicates.and((Predicate)NodePredicates.inGroup((String)input.getName()), (Predicate)NodePredicates.TERMINATED));
    }
}

