/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import org.apache.brooklyn.util.text.BrooklynVersionSyntax;

public class RegisteredTypeNaming {
    private static final String USABLE_REGEX = "[^:\\s/\\\\]+";
    private static final String DOT = "\\.";
    public static final String OSGI_TOKEN_CHARS = "A-Za-z0-9_-";
    public static final String OSGI_TOKEN_REGEX = "[A-Za-z0-9_-]+";
    public static final String OSGI_SYMBOLIC_NAME_REGEX = "[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)*";

    private static boolean isUsable(String candidate) {
        return candidate != null && candidate.matches(USABLE_REGEX);
    }

    public static boolean isUsableTypeName(String candidate) {
        return RegisteredTypeNaming.isUsable(candidate);
    }

    public static boolean isGoodTypeName(String candidate) {
        return RegisteredTypeNaming.isUsable(candidate) && candidate.matches(OSGI_SYMBOLIC_NAME_REGEX);
    }

    public static boolean isUsableVersion(String candidate) {
        return BrooklynVersionSyntax.isUsableVersion((String)candidate);
    }

    public static boolean isGoodBrooklynVersion(String candidate) {
        return BrooklynVersionSyntax.isGoodBrooklynVersion((String)candidate);
    }

    public static boolean isValidOsgiVersion(String candidate) {
        return BrooklynVersionSyntax.isValidOsgiVersion((String)candidate);
    }

    public static boolean isUsableTypeColonVersion(String candidate) {
        return candidate != null && candidate.matches("[^:\\s/\\\\]+:[^:\\s/\\\\]+");
    }

    public static boolean isGoodBrooklynTypeColonVersion(String candidate) {
        if (candidate == null) {
            return false;
        }
        int idx = candidate.indexOf(58);
        if (idx <= 0) {
            return false;
        }
        if (!RegisteredTypeNaming.isGoodTypeName(candidate.substring(0, idx))) {
            return false;
        }
        return RegisteredTypeNaming.isGoodBrooklynVersion(candidate.substring(idx + 1));
    }

    public static boolean isValidOsgiTypeColonVersion(String candidate) {
        if (candidate == null) {
            return false;
        }
        int idx = candidate.indexOf(58);
        if (idx <= 0) {
            return false;
        }
        if (!RegisteredTypeNaming.isGoodTypeName(candidate.substring(0, idx))) {
            return false;
        }
        return RegisteredTypeNaming.isValidOsgiVersion(candidate.substring(idx + 1));
    }
}

