/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;

public class KeyValueParser {
    public static String toLine(Map<String, String> parts) {
        QuotedStringTokenizer tokenizer = new QuotedStringTokenizer("", true);
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : parts.entrySet()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(tokenizer.quoteToken(entry.getKey()));
            if (entry.getValue() == null) continue;
            result.append("=" + tokenizer.quoteToken(entry.getValue()));
        }
        return result.toString();
    }

    public static String toLine(Collection<String> parts) {
        QuotedStringTokenizer tokenizer = new QuotedStringTokenizer("", false);
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            result.append(tokenizer.quoteToken(part) + ", ");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static List<String> parseList(String line) {
        ArrayList<String> result = new ArrayList<String>();
        QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(line, null, true, ",", false);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.unquoteToken(tokenizer.nextToken().trim()));
        }
        return result;
    }

    @Deprecated
    public static Map<String, String> parse(String line) {
        return KeyValueParser.parseMap(line);
    }

    public static Map<String, String> parseMap(String line) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(line, null, true, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String unquotedKey;
            String token = tokenizer.nextToken().trim();
            int index = token.indexOf("=");
            if (index < 0) {
                unquotedKey = tokenizer.unquoteToken(token);
                result.put(unquotedKey, null);
                continue;
            }
            if (index < token.length() - 1) {
                unquotedKey = tokenizer.unquoteToken(token.substring(0, index).trim());
                String unquotedVal = tokenizer.unquoteToken(token.substring(index + 1).trim());
                result.put(unquotedKey, unquotedVal);
                continue;
            }
            assert (index == token.length() - 1);
            unquotedKey = tokenizer.unquoteToken(token.substring(0, index).trim());
            result.put(unquotedKey, "");
        }
        return result;
    }
}

