/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.AbstractMap;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;

public class ByNameAndTextRecSelector
implements ElementSelector {
    @Override
    public boolean canBeCompared(Element controlElement, Element testElement) {
        Map.Entry<Integer, Node> p;
        int controlIndex;
        if (!ElementSelectors.byNameAndText.canBeCompared(controlElement, testElement)) {
            return false;
        }
        NodeList controlChildren = controlElement.getChildNodes();
        NodeList testChildren = testElement.getChildNodes();
        int controlLen = controlChildren.getLength();
        int testLen = testChildren.getLength();
        int testIndex = 0;
        for (controlIndex = 0; controlIndex < controlLen && testIndex < testLen; ++controlIndex, ++testIndex) {
            Map.Entry<Integer, Node> control = ByNameAndTextRecSelector.findNonText(controlChildren, controlIndex, controlLen);
            controlIndex = control.getKey();
            Node c = control.getValue();
            if (ByNameAndTextRecSelector.isText(c)) break;
            Map.Entry<Integer, Node> test = ByNameAndTextRecSelector.findNonText(testChildren, testIndex, testLen);
            testIndex = test.getKey();
            Node t = test.getValue();
            if (ByNameAndTextRecSelector.isText(t)) break;
            if (c.getNodeType() != t.getNodeType()) {
                return false;
            }
            if (!(c instanceof Element) || this.canBeCompared((Element)c, (Element)t)) continue;
            return false;
        }
        if (controlIndex < controlLen && (controlIndex = (p = ByNameAndTextRecSelector.findNonText(controlChildren, controlIndex, controlLen)).getKey().intValue()) < controlLen) {
            return false;
        }
        return testIndex >= testLen || (testIndex = (p = ByNameAndTextRecSelector.findNonText(testChildren, testIndex, testLen)).getKey().intValue()) >= testLen;
    }

    private static Map.Entry<Integer, Node> findNonText(NodeList nl, int current, int len) {
        Node n = nl.item(current);
        while (ByNameAndTextRecSelector.isText(n) && ++current < len) {
            n = nl.item(current);
        }
        return new AbstractMap.SimpleImmutableEntry<Integer, Node>(current, n);
    }

    private static boolean isText(Node n) {
        return n instanceof Text || n instanceof CDATASection;
    }
}

