/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.chef;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallChefGems
implements Statement {
    private Optional<String> version;

    public static Builder builder() {
        return new Builder();
    }

    protected InstallChefGems(Optional<String> version) {
        this.version = version;
    }

    @Override
    public String render(OsFamily family) {
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        Statement statement = this.version.isPresent() ? Statements.exec(String.format("gem install chef -v '%s' --no-rdoc --no-ri", this.version.get())) : Statements.exec("gem install chef --no-rdoc --no-ri");
        return statement.render(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableSet.of();
    }

    public static class Builder {
        private Optional<String> version = Optional.absent();

        public Builder version(@Nullable String version) {
            this.version = Optional.fromNullable((Object)version);
            return this;
        }

        public InstallChefGems build() {
            return new InstallChefGems(this.version);
        }
    }
}

