/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.config;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingObject;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.date.TimeStamp;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedTemporaryUrlBlobSigner;

public class SignUsingTemporaryUrls
extends AbstractModule {
    protected void configure() {
        this.install(new FactoryModuleBuilder().build(Factory.class));
    }

    @Provides
    Function<String, BlobRequestSigner> blobRequestSigner(FactoryFunction in) {
        return in;
    }

    @Provides
    @TimeStamp
    protected Long unixEpochTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    static class FactoryFunction
    extends ForwardingObject
    implements Function<String, BlobRequestSigner> {
        @Inject
        Factory delegate;

        FactoryFunction() {
        }

        protected Factory delegate() {
            return this.delegate;
        }

        public BlobRequestSigner apply(String in) {
            return this.delegate.create(in);
        }
    }

    static interface Factory {
        public RegionScopedTemporaryUrlBlobSigner create(String var1);
    }
}

