/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.location.Iso3166;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class OptionToLocation
implements Function<Option, Location> {
    private final Location provider;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    OptionToLocation(JustProvider justProvider, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        this.provider = (Location)Iterables.getOnlyElement((Iterable)justProvider.get());
        this.isoCodesByIdSupplier = (Supplier)Preconditions.checkNotNull(isoCodesByIdSupplier, (Object)"isoCodesByIdSupplier");
    }

    public Location apply(Option from) {
        LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(from.getId() + "").description(from.getDescription()).parent(this.provider);
        Map isoCodesById = (Map)this.isoCodesByIdSupplier.get();
        if (isoCodesById.containsKey(from.getId() + "")) {
            builder.iso3166Codes((Iterable)((Supplier)isoCodesById.get(from.getId() + "")).get());
        }
        return builder.build();
    }
}

