/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationprofilestatus.traits.Route;
import org.apache.camel.v1.integrationprofilestatus.traits.route.Configuration;
import org.apache.camel.v1.integrationprofilestatus.traits.route.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.route.ConfigurationFluent;

public class RouteFluent<A extends RouteFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private String host;
    private String tlsCACertificate;
    private String tlsCACertificateSecret;
    private String tlsCertificate;
    private String tlsCertificateSecret;
    private String tlsDestinationCACertificate;
    private String tlsDestinationCACertificateSecret;
    private Route.TlsInsecureEdgeTerminationPolicy tlsInsecureEdgeTerminationPolicy;
    private String tlsKey;
    private String tlsKeySecret;
    private Route.TlsTermination tlsTermination;

    public RouteFluent() {
    }

    public RouteFluent(Route instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Route instance) {
        Route route = instance = instance != null ? instance : new Route();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withHost(instance.getHost());
            this.withTlsCACertificate(instance.getTlsCACertificate());
            this.withTlsCACertificateSecret(instance.getTlsCACertificateSecret());
            this.withTlsCertificate(instance.getTlsCertificate());
            this.withTlsCertificateSecret(instance.getTlsCertificateSecret());
            this.withTlsDestinationCACertificate(instance.getTlsDestinationCACertificate());
            this.withTlsDestinationCACertificateSecret(instance.getTlsDestinationCACertificateSecret());
            this.withTlsInsecureEdgeTerminationPolicy(instance.getTlsInsecureEdgeTerminationPolicy());
            this.withTlsKey(instance.getTlsKey());
            this.withTlsKeySecret(instance.getTlsKeySecret());
            this.withTlsTermination(instance.getTlsTermination());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getTlsCACertificate() {
        return this.tlsCACertificate;
    }

    public A withTlsCACertificate(String tlsCACertificate) {
        this.tlsCACertificate = tlsCACertificate;
        return (A)((Object)this);
    }

    public boolean hasTlsCACertificate() {
        return this.tlsCACertificate != null;
    }

    public String getTlsCACertificateSecret() {
        return this.tlsCACertificateSecret;
    }

    public A withTlsCACertificateSecret(String tlsCACertificateSecret) {
        this.tlsCACertificateSecret = tlsCACertificateSecret;
        return (A)((Object)this);
    }

    public boolean hasTlsCACertificateSecret() {
        return this.tlsCACertificateSecret != null;
    }

    public String getTlsCertificate() {
        return this.tlsCertificate;
    }

    public A withTlsCertificate(String tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
        return (A)((Object)this);
    }

    public boolean hasTlsCertificate() {
        return this.tlsCertificate != null;
    }

    public String getTlsCertificateSecret() {
        return this.tlsCertificateSecret;
    }

    public A withTlsCertificateSecret(String tlsCertificateSecret) {
        this.tlsCertificateSecret = tlsCertificateSecret;
        return (A)((Object)this);
    }

    public boolean hasTlsCertificateSecret() {
        return this.tlsCertificateSecret != null;
    }

    public String getTlsDestinationCACertificate() {
        return this.tlsDestinationCACertificate;
    }

    public A withTlsDestinationCACertificate(String tlsDestinationCACertificate) {
        this.tlsDestinationCACertificate = tlsDestinationCACertificate;
        return (A)((Object)this);
    }

    public boolean hasTlsDestinationCACertificate() {
        return this.tlsDestinationCACertificate != null;
    }

    public String getTlsDestinationCACertificateSecret() {
        return this.tlsDestinationCACertificateSecret;
    }

    public A withTlsDestinationCACertificateSecret(String tlsDestinationCACertificateSecret) {
        this.tlsDestinationCACertificateSecret = tlsDestinationCACertificateSecret;
        return (A)((Object)this);
    }

    public boolean hasTlsDestinationCACertificateSecret() {
        return this.tlsDestinationCACertificateSecret != null;
    }

    public Route.TlsInsecureEdgeTerminationPolicy getTlsInsecureEdgeTerminationPolicy() {
        return this.tlsInsecureEdgeTerminationPolicy;
    }

    public A withTlsInsecureEdgeTerminationPolicy(Route.TlsInsecureEdgeTerminationPolicy tlsInsecureEdgeTerminationPolicy) {
        this.tlsInsecureEdgeTerminationPolicy = tlsInsecureEdgeTerminationPolicy;
        return (A)((Object)this);
    }

    public boolean hasTlsInsecureEdgeTerminationPolicy() {
        return this.tlsInsecureEdgeTerminationPolicy != null;
    }

    public String getTlsKey() {
        return this.tlsKey;
    }

    public A withTlsKey(String tlsKey) {
        this.tlsKey = tlsKey;
        return (A)((Object)this);
    }

    public boolean hasTlsKey() {
        return this.tlsKey != null;
    }

    public String getTlsKeySecret() {
        return this.tlsKeySecret;
    }

    public A withTlsKeySecret(String tlsKeySecret) {
        this.tlsKeySecret = tlsKeySecret;
        return (A)((Object)this);
    }

    public boolean hasTlsKeySecret() {
        return this.tlsKeySecret != null;
    }

    public Route.TlsTermination getTlsTermination() {
        return this.tlsTermination;
    }

    public A withTlsTermination(Route.TlsTermination tlsTermination) {
        this.tlsTermination = tlsTermination;
        return (A)((Object)this);
    }

    public boolean hasTlsTermination() {
        return this.tlsTermination != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteFluent that = (RouteFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.tlsCACertificate, that.tlsCACertificate)) {
            return false;
        }
        if (!Objects.equals(this.tlsCACertificateSecret, that.tlsCACertificateSecret)) {
            return false;
        }
        if (!Objects.equals(this.tlsCertificate, that.tlsCertificate)) {
            return false;
        }
        if (!Objects.equals(this.tlsCertificateSecret, that.tlsCertificateSecret)) {
            return false;
        }
        if (!Objects.equals(this.tlsDestinationCACertificate, that.tlsDestinationCACertificate)) {
            return false;
        }
        if (!Objects.equals(this.tlsDestinationCACertificateSecret, that.tlsDestinationCACertificateSecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsInsecureEdgeTerminationPolicy, (Object)that.tlsInsecureEdgeTerminationPolicy)) {
            return false;
        }
        if (!Objects.equals(this.tlsKey, that.tlsKey)) {
            return false;
        }
        if (!Objects.equals(this.tlsKeySecret, that.tlsKeySecret)) {
            return false;
        }
        return Objects.equals((Object)this.tlsTermination, (Object)that.tlsTermination);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.configuration, this.enabled, this.host, this.tlsCACertificate, this.tlsCACertificateSecret, this.tlsCertificate, this.tlsCertificateSecret, this.tlsDestinationCACertificate, this.tlsDestinationCACertificateSecret, this.tlsInsecureEdgeTerminationPolicy, this.tlsKey, this.tlsKeySecret, this.tlsTermination, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.tlsCACertificate != null) {
            sb.append("tlsCACertificate:");
            sb.append(this.tlsCACertificate + ",");
        }
        if (this.tlsCACertificateSecret != null) {
            sb.append("tlsCACertificateSecret:");
            sb.append(this.tlsCACertificateSecret + ",");
        }
        if (this.tlsCertificate != null) {
            sb.append("tlsCertificate:");
            sb.append(this.tlsCertificate + ",");
        }
        if (this.tlsCertificateSecret != null) {
            sb.append("tlsCertificateSecret:");
            sb.append(this.tlsCertificateSecret + ",");
        }
        if (this.tlsDestinationCACertificate != null) {
            sb.append("tlsDestinationCACertificate:");
            sb.append(this.tlsDestinationCACertificate + ",");
        }
        if (this.tlsDestinationCACertificateSecret != null) {
            sb.append("tlsDestinationCACertificateSecret:");
            sb.append(this.tlsDestinationCACertificateSecret + ",");
        }
        if (this.tlsInsecureEdgeTerminationPolicy != null) {
            sb.append("tlsInsecureEdgeTerminationPolicy:");
            sb.append(this.tlsInsecureEdgeTerminationPolicy + ",");
        }
        if (this.tlsKey != null) {
            sb.append("tlsKey:");
            sb.append(this.tlsKey + ",");
        }
        if (this.tlsKeySecret != null) {
            sb.append("tlsKeySecret:");
            sb.append(this.tlsKeySecret + ",");
        }
        if (this.tlsTermination != null) {
            sb.append("tlsTermination:");
            sb.append((Object)this.tlsTermination);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)RouteFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

