/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.Camel;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.camel.Configuration;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.camel.ConfigurationBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.camel.ConfigurationFluent;

public class CamelFluent<A extends CamelFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private List<String> properties;
    private String runtimeVersion;

    public CamelFluent() {
    }

    public CamelFluent(Camel instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Camel instance) {
        Camel camel = instance = instance != null ? instance : new Camel();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withProperties(instance.getProperties());
            this.withRuntimeVersion(instance.getRuntimeVersion());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToProperties(int index, String item) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.add(index, item);
        return (A)((Object)this);
    }

    public A setToProperties(int index, String item) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.set(index, item);
        return (A)((Object)this);
    }

    public A addToProperties(String ... items) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        for (String item : items) {
            this.properties.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProperties(Collection<String> items) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        for (String item : items) {
            this.properties.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(String ... items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.properties.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProperties(Collection<String> items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.properties.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public String getProperty(int index) {
        return this.properties.get(index);
    }

    public String getFirstProperty() {
        return this.properties.get(0);
    }

    public String getLastProperty() {
        return this.properties.get(this.properties.size() - 1);
    }

    public String getMatchingProperty(Predicate<String> predicate) {
        for (String item : this.properties) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<String> predicate) {
        for (String item : this.properties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProperties(List<String> properties) {
        if (properties != null) {
            this.properties = new ArrayList<String>();
            for (String item : properties) {
                this.addToProperties(item);
            }
        } else {
            this.properties = null;
        }
        return (A)((Object)this);
    }

    public A withProperties(String ... properties) {
        if (this.properties != null) {
            this.properties.clear();
            this._visitables.remove((Object)"properties");
        }
        if (properties != null) {
            for (String item : properties) {
                this.addToProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)((Object)this);
    }

    public boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CamelFluent that = (CamelFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        return Objects.equals(this.runtimeVersion, that.runtimeVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.properties, this.runtimeVersion, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.runtimeVersion != null) {
            sb.append("runtimeVersion:");
            sb.append(this.runtimeVersion);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)CamelFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

