/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptionsConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class JWTAuthOptions {
    private static final String PERMISSIONS_CLAIM_KEY = "permissions";
    private static final JWTOptions JWT_OPTIONS = new JWTOptions();
    private String permissionsClaimKey;
    private KeyStoreOptions keyStore;
    private List<PubSecKeyOptions> pubSecKeys;
    private JWTOptions jwtOptions;
    private List<JsonObject> jwks;

    public JWTAuthOptions() {
        this.init();
    }

    public JWTAuthOptions(JWTAuthOptions other) {
        this.permissionsClaimKey = other.getPermissionsClaimKey();
        this.keyStore = other.getKeyStore();
        this.pubSecKeys = other.getPubSecKeys();
        this.jwtOptions = other.getJWTOptions();
        this.jwks = other.getJwks();
    }

    private void init() {
        this.permissionsClaimKey = PERMISSIONS_CLAIM_KEY;
        this.jwtOptions = JWT_OPTIONS;
    }

    public JWTAuthOptions(JsonObject json) {
        this.init();
        JWTAuthOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    @Deprecated
    public String getPermissionsClaimKey() {
        return this.permissionsClaimKey;
    }

    @Deprecated
    public JWTAuthOptions setPermissionsClaimKey(String permissionsClaimKey) {
        this.permissionsClaimKey = permissionsClaimKey;
        return this;
    }

    public KeyStoreOptions getKeyStore() {
        return this.keyStore;
    }

    public JWTAuthOptions setKeyStore(KeyStoreOptions keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public JWTAuthOptions setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public JWTAuthOptions addPubSecKey(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public JWTAuthOptions setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }

    public List<JsonObject> getJwks() {
        return this.jwks;
    }

    public JWTAuthOptions setJwks(List<JsonObject> jwks) {
        this.jwks = jwks;
        return this;
    }

    public JWTAuthOptions addJwk(JsonObject jwk) {
        if (this.jwks == null) {
            this.jwks = new ArrayList<JsonObject>();
        }
        this.jwks.add(jwk);
        return this;
    }
}

