/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.CacheConfiguration;
import org.apache.cassandra.sidecar.config.SSTableImportConfiguration;
import org.apache.cassandra.sidecar.config.yaml.CacheConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.PeriodicTaskConfigurationImpl;

public class SSTableImportConfigurationImpl
extends PeriodicTaskConfigurationImpl
implements SSTableImportConfiguration {
    private static final MillisecondBoundConfiguration DEFAULT_IMPORT_EXECUTE_INTERVAL = MillisecondBoundConfiguration.parse((String)"100ms");
    public static final String CACHE_PROPERTY = "cache";
    protected static final CacheConfiguration DEFAULT_CACHE_CONFIGURATION = new CacheConfigurationImpl(MillisecondBoundConfiguration.parse((String)"2h"), 10000L);
    @JsonProperty(value="cache")
    protected final CacheConfiguration cacheConfiguration;

    public SSTableImportConfigurationImpl() {
        this(DEFAULT_IMPORT_EXECUTE_INTERVAL, DEFAULT_CACHE_CONFIGURATION);
    }

    public SSTableImportConfigurationImpl(CacheConfiguration cacheConfiguration) {
        this(DEFAULT_IMPORT_EXECUTE_INTERVAL, cacheConfiguration);
    }

    public SSTableImportConfigurationImpl(int importIntervalMillis) {
        this(new MillisecondBoundConfiguration((long)importIntervalMillis, TimeUnit.MILLISECONDS), DEFAULT_CACHE_CONFIGURATION);
    }

    public SSTableImportConfigurationImpl(MillisecondBoundConfiguration importExecuteInterval, CacheConfiguration cacheConfiguration) {
        super(true, null, importExecuteInterval);
        this.cacheConfiguration = cacheConfiguration;
    }

    @Override
    @JsonProperty(value="cache")
    public CacheConfiguration cacheConfiguration() {
        return this.cacheConfiguration;
    }
}

