/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoMap;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.MatchType;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.TimeoutHandler;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.sidecar.common.response.TimeSkewResponse;
import org.apache.cassandra.sidecar.config.FileSystemOptionsConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.VertxConfiguration;
import org.apache.cassandra.sidecar.config.VertxMetricsConfiguration;
import org.apache.cassandra.sidecar.handlers.JsonErrorHandler;
import org.apache.cassandra.sidecar.handlers.TimeSkewHandler;
import org.apache.cassandra.sidecar.logging.SidecarLoggerHandler;
import org.apache.cassandra.sidecar.metrics.MetricRegistryFactory;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.MultiBindingTypeResolver;
import org.apache.cassandra.sidecar.modules.multibindings.RouteClassKey;
import org.apache.cassandra.sidecar.modules.multibindings.VertxRouteMapKeys;
import org.apache.cassandra.sidecar.routes.RouteBuilder;
import org.apache.cassandra.sidecar.routes.RoutingOrder;
import org.apache.cassandra.sidecar.routes.SettableVertxRoute;
import org.apache.cassandra.sidecar.routes.VertxRoute;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;

@Path(value="/")
public class ApiModule
extends AbstractModule {
    public static final Map<String, String> OK_STATUS = Collections.singletonMap("status", "OK");
    public static final Map<String, String> NOT_OK_STATUS = Collections.singletonMap("status", "NOT_OK");

    @Provides
    @Singleton
    Router vertxRouter(Vertx vertx, MultiBindingTypeResolver<VertxRoute> resolver) {
        Router router = Router.router((Vertx)vertx);
        resolver.resolve().forEach((routeClassKey, route) -> {
            try {
                if (RouteClassKey.class.isAssignableFrom((Class<?>)routeClassKey)) {
                    Class key = routeClassKey;
                    SettableVertxRoute settableVertxRoute = (SettableVertxRoute)route;
                    settableVertxRoute.setRouteClassKey(key);
                }
                route.mountTo(router);
            }
            catch (Throwable cause) {
                throw new RuntimeException("Failed to mount route: " + routeClassKey.getSimpleName(), cause);
            }
        });
        return router;
    }

    @Provides
    @Singleton
    Vertx vertx(SidecarConfiguration sidecarConfiguration, MetricRegistryFactory metricRegistryFactory) {
        FileSystemOptionsConfiguration fsOptions;
        VertxMetricsConfiguration metricsConfig = sidecarConfiguration.metricsConfiguration().vertxConfiguration();
        Match serverRouteMatch = new Match().setValue("/api/v1/.*").setType(MatchType.REGEX);
        DropwizardMetricsOptions dropwizardMetricsOptions = new DropwizardMetricsOptions().setEnabled(metricsConfig.enabled()).setJmxEnabled(metricsConfig.exposeViaJMX()).setJmxDomain(metricsConfig.jmxDomainName()).setMetricRegistry(metricRegistryFactory.getOrCreate()).addMonitoredHttpServerRoute(serverRouteMatch);
        VertxOptions vertxOptions = new VertxOptions().setMetricsOptions((MetricsOptions)dropwizardMetricsOptions);
        VertxConfiguration vertxConfiguration = sidecarConfiguration.vertxConfiguration();
        FileSystemOptionsConfiguration fileSystemOptionsConfiguration = fsOptions = vertxConfiguration != null ? vertxConfiguration.filesystemOptionsConfiguration() : null;
        if (fsOptions != null) {
            vertxOptions.setFileSystemOptions(new FileSystemOptions().setClassPathResolvingEnabled(fsOptions.classpathResolvingEnabled()).setFileCacheDir(fsOptions.fileCacheDir()).setFileCachingEnabled(fsOptions.fileCachingEnabled()));
        }
        return Vertx.vertx((VertxOptions)vertxOptions);
    }

    @Provides
    @Singleton
    ErrorHandler errorHandler() {
        return new JsonErrorHandler();
    }

    @Provides
    @Singleton
    LoggerHandler loggerHandler() {
        return SidecarLoggerHandler.create(LoggerHandler.create());
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.GlobalUtilityHandlerKey.class)
    VertxRoute globalUtilityHandler(SidecarConfiguration sidecarConfiguration, LoggerHandler loggerHandler) {
        return VertxRoute.create(router -> router.route().order(RoutingOrder.HIGHEST.order).handler((Handler)loggerHandler).handler((Handler)TimeoutHandler.create((long)sidecarConfiguration.serviceConfiguration().requestTimeout().toMillis(), (int)HttpResponseStatus.REQUEST_TIMEOUT.code())));
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.GlobalErrorHandlerKey.class)
    VertxRoute globalErrorHandler(ErrorHandler errorHandler) {
        return VertxRoute.create(router -> router.route().path("/api/*").failureHandler((Handler)errorHandler));
    }

    @GET
    @Path(value="/api/v1/time-skew")
    @Operation(summary="Get time skew information", description="Returns time skew information for the node")
    @APIResponse(description="Time skew information retrieved successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=TimeSkewResponse.class))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.TimeSkewRouteKey.class)
    VertxRoute timeSkewRoute(RouteBuilder.Factory factory, TimeSkewHandler timeSkewHandler) {
        return factory.builderForUnauthorizedRoute().handler(timeSkewHandler).build();
    }
}

