/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.db;

import com.datastax.driver.core.ResultSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.cassandra.sidecar.db.DataObjectMappingException;
import org.jetbrains.annotations.NotNull;

public class ConnectedClientStatsSummary {
    public final int totalConnectedClients;
    public final Map<String, Long> connectionsByUser;

    public static ConnectedClientStatsSummary from(@NotNull ResultSet resultSet) throws DataObjectMappingException {
        Map<String, Long> resultMap = StreamSupport.stream(resultSet.spliterator(), false).collect(Collectors.toMap(r -> r.getString("username"), r -> r.getLong("connection_count")));
        int totalConnections = resultMap.values().stream().mapToInt(Math::toIntExact).sum();
        return new ConnectedClientStatsSummary(resultMap, totalConnections);
    }

    public ConnectedClientStatsSummary(Map<String, Long> connectionsByUser, int totalConnections) {
        this.totalConnectedClients = totalConnections;
        this.connectionsByUser = connectionsByUser;
    }
}

