/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.trans.ProcedureTranslator;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ProcedureQuery;

class DB2ProcedureAction
extends ProcedureAction {
    DB2ProcedureAction(ProcedureQuery query, JdbcAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        ProcedureTranslator transl = this.createTranslator(connection);
        CallableStatement statement = (CallableStatement)transl.createStatement();
        try {
            this.initStatement(statement);
            boolean hasResultSet = statement.execute();
            this.readProcedureOutParameters(statement, observer);
            while (true) {
                if (hasResultSet) {
                    ResultSet rs = statement.getResultSet();
                    try {
                        RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, observer);
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                this.adapter.getJdbcEventLogger().logUpdateCount(updateCount);
                observer.nextCount(this.query, updateCount);
                hasResultSet = statement.getMoreResults();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

