/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.BindingBuilder;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.CustomProvidersProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InstanceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBindingBuilder<T>
implements BindingBuilder<T> {
    protected DefaultInjector injector;
    protected Key<T> bindingKey;

    DefaultBindingBuilder(Key<T> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) throws ConfigurationException {
        ConstructorInjectingProvider<? extends T> provider0 = new ConstructorInjectingProvider<T>(implementation, this.injector);
        FieldInjectingProvider<? extends T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.injector.putBinding(this.bindingKey, provider1);
        return this;
    }

    @Override
    public BindingBuilder<T> toInstance(T instance) throws ConfigurationException {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(instance);
        FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.injector.putBinding(this.bindingKey, provider1);
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends Provider<? extends T>> providerType) {
        ConstructorInjectingProvider<? extends Provider<? extends T>> provider0 = new ConstructorInjectingProvider<Provider<? extends T>>(providerType, this.injector);
        FieldInjectingProvider provider1 = new FieldInjectingProvider(provider0, this.injector);
        CustomProvidersProvider provider2 = new CustomProvidersProvider(provider1);
        FieldInjectingProvider provider3 = new FieldInjectingProvider(provider2, this.injector);
        this.injector.putBinding(this.bindingKey, provider3);
        return this;
    }

    @Override
    public BindingBuilder<T> toProviderInstance(Provider<? extends T> provider) {
        InstanceProvider<Provider<? extends T>> provider0 = new InstanceProvider<Provider<? extends T>>(provider);
        FieldInjectingProvider<Provider<? extends T>> provider1 = new FieldInjectingProvider<Provider<? extends T>>(provider0, this.injector);
        CustomProvidersProvider<? extends T> provider2 = new CustomProvidersProvider<T>(provider1);
        FieldInjectingProvider<? extends T> provider3 = new FieldInjectingProvider<T>(provider2, this.injector);
        this.injector.putBinding(this.bindingKey, provider3);
        return this;
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }

    @Override
    public void withoutScope() {
        this.in(this.injector.getNoScope());
    }

    @Override
    public void inSingletonScope() {
        this.in(this.injector.getSingletonScope());
    }
}

