/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.graph.BaseGraphBuilder;
import org.apache.cayenne.modeler.graph.EntityCellMetadata;
import org.apache.cayenne.modeler.graph.GraphType;
import org.apache.cayenne.modeler.graph.ObjEntityCellMetadata;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjGraphBuilder
extends BaseGraphBuilder
implements ObjEntityListener,
ObjAttributeListener,
ObjRelationshipListener {
    static final Color ENTITY_COLOR = new Color(255, 255, 185);
    Map<Entity, DefaultEdge> inheritanceEdges = new HashMap<Entity, DefaultEdge>();

    @Override
    protected Collection<? extends Entity> getEntities(DataMap map) {
        return map.getObjEntities();
    }

    @Override
    protected boolean isIsolated(DataChannelDescriptor domain, Entity entity) {
        if (!super.isIsolated(domain, entity)) {
            return false;
        }
        if (((ObjEntity)entity).getSuperEntity() != null) {
            return false;
        }
        EntityResolver resolver = new EntityResolver(((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps());
        EntityInheritanceTree inheritanceTree = resolver.lookupInheritanceTree(entity.getName());
        return inheritanceTree == null || inheritanceTree.getChildren().isEmpty();
    }

    @Override
    protected void postProcessEntity(Entity entity, DefaultGraphCell cell) {
        super.postProcessEntity(entity, cell);
        GraphConstants.setBackground(cell.getAttributes(), ENTITY_COLOR);
        GraphConstants.setOpaque(cell.getAttributes(), true);
        DefaultEdge edge = this.createInheritanceEdge((ObjEntity)entity);
        if (edge != null) {
            this.createdObjects.add(edge);
        }
    }

    DefaultEdge createInheritanceEdge(ObjEntity entity) {
        ObjEntity superEntity;
        if (!this.inheritanceEdges.containsKey(entity) && (superEntity = entity.getSuperEntity()) != null) {
            DefaultGraphCell sourceCell = (DefaultGraphCell)this.entityCells.get(entity.getName());
            DefaultGraphCell targetCell = (DefaultGraphCell)this.entityCells.get(superEntity.getName());
            DefaultEdge edge = new DefaultEdge();
            edge.setSource(sourceCell.getChildAt(0));
            edge.setTarget(targetCell.getChildAt(0));
            GraphConstants.setDashPattern(edge.getAttributes(), new float[]{5.0f, 5.0f});
            GraphConstants.setLineEnd(edge.getAttributes(), 2);
            GraphConstants.setSelectable(edge.getAttributes(), false);
            this.inheritanceEdges.put(entity, edge);
            return edge;
        }
        return null;
    }

    @Override
    protected EntityCellMetadata getCellMetadata(Entity e) {
        return new ObjEntityCellMetadata(this, e.getName());
    }

    @Override
    public void setProjectController(ProjectController mediator) {
        super.setProjectController(mediator);
        mediator.addObjEntityListener(this);
        mediator.addObjAttributeListener(this);
        mediator.addObjRelationshipListener(this);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mediator.removeObjEntityListener(this);
        this.mediator.removeObjAttributeListener(this);
        this.mediator.removeObjRelationshipListener(this);
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        this.insertEntityCell(e.getEntity());
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        this.remapEntity(e);
        this.updateEntityCell(e.getEntity());
        ObjEntity entity = (ObjEntity)e.getEntity();
        DefaultEdge inheritanceEdge = this.inheritanceEdges.get(entity);
        if (inheritanceEdge != null) {
            if (entity.getSuperEntity() == null) {
                this.graph.getGraphLayoutCache().remove(new Object[]{inheritanceEdge});
                this.inheritanceEdges.remove(entity);
            } else {
                inheritanceEdge.setTarget(((DefaultGraphCell)this.entityCells.get(entity.getSuperEntity().getName())).getChildAt(0));
                HashMap<DefaultEdge, AttributeMap> nested = new HashMap<DefaultEdge, AttributeMap>();
                nested.put(inheritanceEdge, inheritanceEdge.getAttributes());
                this.graph.getGraphLayoutCache().edit(nested);
            }
        } else if (entity.getSuperEntity() != null) {
            DefaultEdge edge = this.createInheritanceEdge(entity);
            this.graph.getGraphLayoutCache().insert(edge);
        }
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        this.removeEntityCell(e.getEntity());
    }

    @Override
    public void objAttributeAdded(AttributeEvent e) {
        this.updateEntityCell(e.getEntity());
    }

    @Override
    public void objAttributeChanged(AttributeEvent e) {
        this.updateEntityCell(e.getEntity());
    }

    @Override
    public void objAttributeRemoved(AttributeEvent e) {
        this.updateEntityCell(e.getEntity());
    }

    @Override
    public void objRelationshipAdded(RelationshipEvent e) {
    }

    @Override
    public void objRelationshipChanged(RelationshipEvent e) {
        this.remapRelationship(e);
        this.updateRelationshipCell(e.getRelationship());
    }

    @Override
    public void objRelationshipRemoved(RelationshipEvent e) {
        this.removeRelationshipCell(e.getRelationship());
    }

    @Override
    protected void removeEntityCell(Entity e) {
        super.removeEntityCell(e);
        this.inheritanceEdges.remove(e);
    }

    @Override
    public GraphType getType() {
        return GraphType.CLASS;
    }
}

