/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v6;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.PasswordEncoding;
import org.apache.cayenne.configuration.SAXNestedTagHandler;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class XMLDataSourceInfoLoader_V3_0_0_1 {
    private static Log logger = LogFactory.getLog(XMLDataSourceInfoLoader_V3_0_0_1.class);

    XMLDataSourceInfoLoader_V3_0_0_1() {
    }

    private static String passwordFromURL(URL url) {
        InputStream inputStream = null;
        String password = null;
        try {
            inputStream = url.openStream();
            password = XMLDataSourceInfoLoader_V3_0_0_1.passwordFromInputStream(inputStream);
        }
        catch (IOException exception) {
            logger.warn((Object)exception);
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String passwordFromInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        String password = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            password = bufferedReader.readLine();
        }
        catch (IOException exception) {
            logger.warn((Object)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return password;
    }

    DataSourceInfo load(Resource configurationSource) {
        if (configurationSource == null) {
            throw new NullPointerException("Null configurationSource");
        }
        URL configurationURL = configurationSource.getURL();
        DataSourceInfo dataSourceInfo = new DataSourceInfo();
        InputStream in = null;
        try {
            in = configurationURL.openStream();
            XMLReader parser = Util.createXmlReader();
            DriverHandler rootHandler = new DriverHandler(parser, dataSourceInfo);
            parser.setContentHandler((ContentHandler)((Object)rootHandler));
            parser.setErrorHandler((ErrorHandler)((Object)rootHandler));
            parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration from %s", (Throwable)e, new Object[]{configurationURL});
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioex) {
                logger.info((Object)("failure closing input stream for " + configurationURL + ", ignoring"), (Throwable)ioex);
            }
        }
        return dataSourceInfo;
    }

    class DataSourceChildrenHandler
    extends SAXNestedTagHandler {
        private DataSourceInfo dataSourceDescriptor;

        DataSourceChildrenHandler(XMLReader parser, DriverHandler parentHandler) {
            super(parser, (SAXNestedTagHandler)parentHandler);
            this.dataSourceDescriptor = parentHandler.dataSourceDescriptor;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals("login")) {
                String encoderClass = attributes.getValue("encoderClass");
                String encoderKey = attributes.getValue("encoderKey");
                if (encoderKey == null) {
                    encoderKey = attributes.getValue("encoderSalt");
                }
                String password = attributes.getValue("password");
                String passwordLocation = attributes.getValue("passwordLocation");
                String passwordSource = attributes.getValue("passwordSource");
                if (passwordSource == null) {
                    passwordSource = "model";
                }
                String username = attributes.getValue("userName");
                this.dataSourceDescriptor.setPasswordEncoderClass(encoderClass);
                this.dataSourceDescriptor.setPasswordEncoderKey(encoderKey);
                this.dataSourceDescriptor.setPasswordLocation(passwordLocation);
                this.dataSourceDescriptor.setPasswordSource(passwordSource);
                this.dataSourceDescriptor.setUserName(username);
                if (encoderKey != null) {
                    passwordSource = passwordSource.replaceAll("\\{\\}", encoderKey);
                }
                PasswordEncoding passwordEncoder = this.dataSourceDescriptor.getPasswordEncoder();
                if (passwordLocation != null) {
                    if (passwordLocation.equals("classpath")) {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        URL url = classLoader.getResource(username);
                        if (url != null) {
                            password = XMLDataSourceInfoLoader_V3_0_0_1.passwordFromURL(url);
                        } else {
                            logger.error((Object)("Could not find resource in CLASSPATH: " + passwordSource));
                        }
                    } else if (passwordLocation.equals("url")) {
                        try {
                            password = XMLDataSourceInfoLoader_V3_0_0_1.passwordFromURL(new URL(passwordSource));
                        }
                        catch (MalformedURLException exception) {
                            logger.warn((Object)exception);
                        }
                    } else if (passwordLocation.equals("executable") && passwordSource != null) {
                        try {
                            Process process = Runtime.getRuntime().exec(passwordSource);
                            password = XMLDataSourceInfoLoader_V3_0_0_1.passwordFromInputStream(process.getInputStream());
                            process.waitFor();
                        }
                        catch (IOException exception) {
                            logger.warn((Object)exception);
                        }
                        catch (InterruptedException exception) {
                            logger.warn((Object)exception);
                        }
                    }
                }
                if (password != null && passwordEncoder != null) {
                    this.dataSourceDescriptor.setPassword(passwordEncoder.decodePassword(password, encoderKey));
                }
            } else if (localName.equals("url")) {
                this.dataSourceDescriptor.setDataSourceUrl(attributes.getValue("value"));
            } else if (localName.equals("connectionPool")) {
                String max;
                String min = attributes.getValue("min");
                if (min != null) {
                    try {
                        this.dataSourceDescriptor.setMinConnections(Integer.parseInt(min));
                    }
                    catch (NumberFormatException nfex) {
                        logger.info((Object)"Non-numeric 'min' attribute", (Throwable)nfex);
                        throw new ConfigurationException("Non-numeric 'min' attribute '%s'", (Throwable)nfex, new Object[]{min});
                    }
                }
                if ((max = attributes.getValue("max")) != null) {
                    try {
                        this.dataSourceDescriptor.setMaxConnections(Integer.parseInt(max));
                    }
                    catch (NumberFormatException nfex) {
                        logger.info((Object)"Non-numeric 'max' attribute", (Throwable)nfex);
                        throw new ConfigurationException("Non-numeric 'max' attribute '%s'", (Throwable)nfex, new Object[]{max});
                    }
                }
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    final class DriverHandler
    extends SAXNestedTagHandler {
        private DataSourceInfo dataSourceDescriptor;

        DriverHandler(XMLReader parser, DataSourceInfo dataSourceDescriptor) {
            super(parser, null);
            this.dataSourceDescriptor = dataSourceDescriptor;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals("driver")) {
                String className = attributes.getValue("", "class");
                this.dataSourceDescriptor.setJdbcDriver(className);
                return new DataSourceChildrenHandler(this.parser, this);
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }
}

