/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.PrintWriter;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.parser.ASTScalar;

public class ASTNamedParameter
extends ASTScalar {
    ASTNamedParameter(int id) {
        super(id);
    }

    public ASTNamedParameter() {
        super(27);
    }

    public ASTNamedParameter(Object value) {
        super(27);
        this.setValue(value);
    }

    protected Object evaluateNode(Object o) throws Exception {
        throw new ExpressionException("Uninitialized parameter: " + this.value + ", call 'expWithParameters' first.", new Object[0]);
    }

    public Expression shallowCopy() {
        ASTNamedParameter copy = new ASTNamedParameter(this.id);
        copy.value = this.value;
        return copy;
    }

    public void setValue(Object value) {
        if (value == null) {
            throw new ExpressionException("Null Parameter value", new Object[0]);
        }
        String name = value.toString().trim();
        if (name.length() == 0) {
            throw new ExpressionException("Empty Parameter value", new Object[0]);
        }
        super.setValue(new ExpressionParameter(name));
    }

    public void encodeAsEJBQL(PrintWriter pw, String rootId) {
        String valueString;
        if (this.value != null && (valueString = this.value.toString()).length() > 1 && valueString.charAt(0) == '$') {
            pw.print(':');
            pw.print(valueString.substring(1));
            return;
        }
        super.encodeAsEJBQL(pw, rootId);
    }
}

