/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.List;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.AbstractRemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CreateCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.CreateObjEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerAction;
import org.apache.cayenne.modeler.editor.AbstractCallbackListenersTab;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneAction;

public class ObjEntityCallbackListenersTab
extends AbstractCallbackListenersTab {
    public ObjEntityCallbackListenersTab(ProjectController mediator) {
        super(mediator);
    }

    protected CallbackMap getCallbackMap() {
        String listenerClass = (String)this.listenerClassCombo.getSelectedItem();
        if (this.mediator.getCurrentObjEntity() != null && this.mediator.getCurrentObjEntity().getEntityListener(listenerClass) != null) {
            return this.mediator.getCurrentObjEntity().getEntityListener(listenerClass).getCallbackMap();
        }
        return null;
    }

    protected void initController() {
        super.initController();
        this.mediator.addObjEntityDisplayListener(new ObjEntityDisplayListener(){

            public void currentObjEntityChanged(EntityDisplayEvent e) {
                if (ObjEntityCallbackListenersTab.this.isVisible()) {
                    ObjEntityCallbackListenersTab.this.rebuildListenerClassCombo(null);
                    ObjEntityCallbackListenersTab.this.updateCallbackTypeCounters();
                    ObjEntityCallbackListenersTab.this.mediator.setCurrentCallbackType((CallbackType)ObjEntityCallbackListenersTab.this.callbackTypeCombo.getSelectedItem());
                    ObjEntityCallbackListenersTab.this.rebuildTable();
                }
            }
        });
    }

    protected List getEntityListeners() {
        return this.mediator.getCurrentObjEntity() == null ? null : this.mediator.getCurrentObjEntity().getEntityListeners();
    }

    protected CayenneAction getCreateCallbackMethodAction() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        return actionManager.getAction(CreateCallbackMethodForListenerAction.class);
    }

    protected AbstractRemoveCallbackMethodAction getRemoveCallbackMethodAction() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        return actionManager.getAction(RemoveCallbackMethodForListenerAction.class);
    }

    protected CayenneAction getRemoveEntityListenerAction() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        return actionManager.getAction(RemoveEntityListenerAction.class);
    }

    public CayenneAction getCreateEntityListenerAction() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        return actionManager.getAction(CreateObjEntityListenerAction.class);
    }

    protected EntityListener getEntityListener(String listenerClass) {
        return this.mediator.getCurrentObjEntity().getEntityListener(listenerClass);
    }

    protected void initTablePreferences() {
        this.tablePreferences = new TableColumnPreferences(this.getClass(), "objEntity/callbackTable");
    }
}

