/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class MultiColumnBrowser
extends JPanel {
    protected static final ImageIcon rightArrow = ModelerUtil.buildIcon("scroll_right.gif");
    public static final int DEFAULT_MIN_COLUMNS_COUNT = 3;
    protected int minColumns;
    protected ListCellRenderer renderer;
    protected TreeModel model;
    protected Object[] selectionPath;
    protected Dimension preferredColumnSize;
    protected List<BrowserPanel> columns;
    protected ListSelectionListener browserSelector;
    protected List<TreeSelectionListener> treeSelectionListeners;
    private boolean fireDisabled;

    public MultiColumnBrowser() {
        this(3);
    }

    public MultiColumnBrowser(int minColumns) {
        if (minColumns < 3) {
            throw new IllegalArgumentException("Expected 3 or more columns, got: " + minColumns);
        }
        this.minColumns = minColumns;
        this.browserSelector = new PanelController();
        this.treeSelectionListeners = Collections.synchronizedList(new ArrayList());
        this.initView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeSelectionListener(TreeSelectionListener listener) {
        List<TreeSelectionListener> list = this.treeSelectionListeners;
        synchronized (list) {
            if (listener != null && !this.treeSelectionListeners.contains(listener)) {
                this.treeSelectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        List<TreeSelectionListener> list = this.treeSelectionListeners;
        synchronized (list) {
            this.treeSelectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTreeSelectionEvent(Object[] selectionPath) {
        if (this.fireDisabled) {
            return;
        }
        TreeSelectionEvent e = new TreeSelectionEvent((Object)this, new TreePath(selectionPath), false, null, null);
        List<TreeSelectionListener> list = this.treeSelectionListeners;
        synchronized (list) {
            for (TreeSelectionListener listener : this.treeSelectionListeners) {
                listener.valueChanged(e);
            }
        }
    }

    public TreePath getSelectionPath() {
        return new TreePath(this.selectionPath);
    }

    public void setSelectionPath(TreePath path) {
        try {
            this.fireDisabled = true;
            for (int i = 0; i < path.getPathCount(); ++i) {
                this.selectRow(path.getPathComponent(i), i, path);
            }
        }
        finally {
            this.fireDisabled = false;
        }
    }

    protected void selectRow(Object row, int index, TreePath path) {
        if (index > 0 && this.columns.get(index - 1).getSelectedValue() != row) {
            this.columns.get(index - 1).setSelectedValue(row, true);
        } else {
            this.updateFromModel(row, index - 1);
        }
    }

    public int getMinColumns() {
        return this.minColumns;
    }

    public void setMinColumns(int minColumns) {
        this.minColumns = minColumns;
    }

    public Dimension getPreferredColumnSize() {
        return this.preferredColumnSize;
    }

    public void setPreferredColumnSize(Dimension preferredColumnSize) {
        this.preferredColumnSize = preferredColumnSize;
        this.refreshPreferredSize();
    }

    public void setDefaultRenderer() {
        if (!(this.renderer instanceof MultiColumnBrowserRenderer)) {
            this.setRenderer(new MultiColumnBrowserRenderer());
        }
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public synchronized void setRenderer(ListCellRenderer renderer) {
        if (this.renderer != renderer) {
            this.renderer = renderer;
            if (this.columns != null && this.columns.size() > 0) {
                for (JList jList : this.columns) {
                    jList.setCellRenderer(renderer);
                }
            }
        }
    }

    public synchronized void setModel(TreeModel model) {
        if (model == null) {
            throw new NullPointerException("Null tree model.");
        }
        if (this.model != model) {
            this.model = model;
            this.updateFromModel(model.getRoot(), -1);
        }
    }

    public TreeModel getModel() {
        return this.model;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    private void initView() {
        this.columns = Collections.synchronizedList(new ArrayList(this.minColumns));
        this.adjustViewColumns(this.minColumns);
    }

    private void adjustViewColumns(int delta) {
        if (delta == 0) {
            return;
        }
        this.setLayout(new GridLayout(1, this.columns.size() + delta, 3, 3));
        if (delta > 0) {
            for (int i = 0; i < delta; ++i) {
                this.appendColumn();
            }
        } else {
            for (int i = -delta; i > 0 && this.columns.size() > this.minColumns; --i) {
                this.removeLastColumn();
            }
        }
        this.refreshPreferredSize();
        this.revalidate();
    }

    private BrowserPanel appendColumn() {
        BrowserPanel panel = new BrowserPanel();
        this.installColumn(panel);
        this.columns.add(panel);
        JScrollPane scroller = new JScrollPane(panel, 20, 31);
        if (this.preferredColumnSize != null) {
            scroller.setPreferredSize(this.preferredColumnSize);
        }
        this.add(scroller);
        return panel;
    }

    protected void installColumn(BrowserPanel panel) {
        panel.addListSelectionListener(this.browserSelector);
        panel.setCellRenderer(this.renderer);
    }

    private BrowserPanel removeLastColumn() {
        if (this.columns.size() == 0) {
            return null;
        }
        int index = this.columns.size() - 1;
        BrowserPanel panel = this.columns.remove(index);
        this.uninstallColumn(panel);
        this.remove(index);
        return panel;
    }

    public void clearSelection() {
        this.updateFromModel(this.model.getRoot(), -1);
    }

    protected void uninstallColumn(BrowserPanel panel) {
        panel.removeListSelectionListener(this.browserSelector);
    }

    private void refreshPreferredSize() {
        if (this.preferredColumnSize != null) {
            int w = this.getColumnsCount() * (this.preferredColumnSize.width + 3) + 3;
            int h = this.preferredColumnSize.height + 6;
            this.setPreferredSize(new Dimension(w, h));
        }
    }

    private void scrollToColumn(int column) {
        if (this.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            double x = (double)(this.getWidth() * column) / (double)this.getMinColumns();
            double y = this.getHeight() / 2;
            if (this.preferredColumnSize != null && (x -= (double)(this.preferredColumnSize.width / 2)) < 0.0) {
                x = 0.0;
            }
            Rectangle rectangle = new Rectangle((int)x, (int)y, 1, 1);
            viewport.scrollRectToVisible(rectangle);
        }
    }

    protected synchronized void updateFromModel(Object selectedNode, int panelIndex) {
        this.updateFromModel(selectedNode, panelIndex, true);
    }

    protected synchronized void updateFromModel(Object selectedNode, int panelIndex, boolean load) {
        if (this.selectionPath == null) {
            this.selectionPath = new Object[0];
        }
        int lastIndex = this.selectionPath.length;
        for (int i = panelIndex + 1; i <= lastIndex && i >= 0 && i < this.columns.size(); ++i) {
            BrowserPanel column = this.columns.get(i);
            column.getSelectionModel().clearSelection();
            column.setRootNode(null);
        }
        this.selectionPath = this.rebuildPath(this.selectionPath, selectedNode, panelIndex);
        if (load) {
            ++panelIndex;
        }
        this.adjustViewColumns(panelIndex + 1 - this.columns.size());
        if (load && !this.model.isLeaf(selectedNode)) {
            BrowserPanel lastPanel = this.columns.get(panelIndex);
            lastPanel.setRootNode(selectedNode);
            this.scrollToColumn(panelIndex);
        }
        this.fireTreeSelectionEvent(this.selectionPath);
    }

    private Object[] rebuildPath(Object[] path, Object node, int panelIndex) {
        Object[] newPath = new Object[panelIndex + 2];
        System.arraycopy(path, 0, newPath, 0, panelIndex + 1);
        newPath[panelIndex + 1] = node;
        return newPath;
    }

    final class MultiColumnBrowserRenderer
    implements ListCellRenderer,
    Serializable {
        ListCellRenderer leafRenderer = CellRenderers.listRenderer();
        JPanel nonLeafPanel;
        ListCellRenderer nonLeafTextRenderer;

        MultiColumnBrowserRenderer() {
            this.nonLeafTextRenderer = new DefaultListCellRenderer(){

                public Border getBorder() {
                    return null;
                }
            };
            this.nonLeafPanel = new JPanel();
            this.nonLeafPanel.setLayout(new BorderLayout());
            this.nonLeafPanel.add((Component)new JLabel(rightArrow), "East");
            this.nonLeafPanel.add((Component)((Object)this.nonLeafTextRenderer), "West");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (MultiColumnBrowser.this.getModel().isLeaf(value)) {
                return this.leafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            String renderedValue = ModelerUtil.getObjectName(value);
            if (renderedValue == null) {
                renderedValue = " ";
            }
            Component text = this.nonLeafTextRenderer.getListCellRendererComponent(list, renderedValue, index, isSelected, cellHasFocus);
            this.nonLeafPanel.setComponentOrientation(text.getComponentOrientation());
            this.nonLeafPanel.setBackground(text.getBackground());
            this.nonLeafPanel.setForeground(text.getForeground());
            this.nonLeafPanel.setEnabled(text.isEnabled());
            return this.nonLeafPanel;
        }
    }

    final class PanelController
    implements ListSelectionListener {
        PanelController() {
        }

        public void valueChanged(ListSelectionEvent e) {
            BrowserPanel panel;
            Object selectedNode;
            if (!e.getValueIsAdjusting() && (selectedNode = (panel = (BrowserPanel)e.getSource()).getSelectedValue()) != null) {
                MultiColumnBrowser.this.updateFromModel(selectedNode, MultiColumnBrowser.this.columns.indexOf(panel));
            }
        }
    }

    protected final class BrowserPanel
    extends JList {
        BrowserPanel() {
            this.setModel(new ColumnListModel());
            this.setSelectionMode(0);
        }

        void setRootNode(Object node) {
            ((ColumnListModel)this.getModel()).setTreeNode(node);
        }

        Object getTreeNode() {
            return ((ColumnListModel)this.getModel()).treeNode;
        }
    }

    final class ColumnListModel
    extends AbstractListModel {
        Object treeNode;
        int children;

        ColumnListModel() {
        }

        void setTreeNode(Object treeNode) {
            int oldChildren = this.children;
            this.treeNode = treeNode;
            this.children = treeNode != null ? MultiColumnBrowser.this.model.getChildCount(treeNode) : 0;
            super.fireContentsChanged(MultiColumnBrowser.this, 0, Math.max(oldChildren, this.children));
        }

        public Object getElementAt(int index) {
            return MultiColumnBrowser.this.model.getChild(this.treeNode, index);
        }

        public int getSize() {
            return this.children;
        }
    }
}

