/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class SelectQueryValidator
extends ConfigurationNodeValidator {
    SelectQueryValidator() {
    }

    void validate(SelectQuery query, ValidationResult validationResult) {
        this.validateName(query, validationResult);
        Entity root = this.validateRoot(query, validationResult);
        if (root != null) {
            this.validateQualifier(root, query.getQualifier(), validationResult);
            for (Ordering ordering : query.getOrderings()) {
                this.validateOrdering(query, root, ordering, validationResult);
            }
            if (query.getPrefetchTree() != null) {
                for (PrefetchTreeNode prefetchTreeNode : query.getPrefetchTree().nonPhantomNodes()) {
                    this.validatePrefetch(root, prefetchTreeNode.getPath(), validationResult);
                }
            }
        }
    }

    void validatePrefetch(Entity root, String path, ValidationResult validationResult) {
    }

    void validateOrdering(SelectQuery query, Entity root, Ordering ordering, ValidationResult validationResult) {
        String path = ordering.getSortSpecString();
        Iterator<CayenneMapEntry> it = root.resolvePathComponents(path);
        while (it.hasNext()) {
            try {
                it.next();
            }
            catch (ExpressionException e) {
                this.addFailure(validationResult, query, "Invalid ordering path: '%s'", path);
            }
        }
    }

    void validateQualifier(Entity root, Expression qualifier, ValidationResult validationResult) {
    }

    Entity validateRoot(SelectQuery query, ValidationResult validationResult) {
        DataMap parent;
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            this.addFailure(validationResult, query, "Query '%s' has no root", query.getName());
            return null;
        }
        if (query.getRoot() == map) {
            return null;
        }
        if (map == null) {
            return query.getRoot() instanceof Entity ? (Entity)query.getRoot() : null;
        }
        if (query.getRoot() instanceof Entity) {
            return (Entity)query.getRoot();
        }
        if (query.getRoot() instanceof Class) {
            return null;
        }
        if (query.getRoot() instanceof String && (parent = query.getDataMap()) != null) {
            return parent.getNamespace().getObjEntity((String)query.getRoot());
        }
        return null;
    }

    void validateName(SelectQuery query, ValidationResult validationResult) {
        String name = query.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, query, "Unnamed SelectQuery", new Object[0]);
            return;
        }
        DataMap map = query.getDataMap();
        if (map == null) {
            return;
        }
        for (Query otherQuery : map.getQueries()) {
            if (otherQuery == query || !name.equals(otherQuery.getName())) continue;
            this.addFailure(validationResult, query, "Duplicate query name: %s", name);
            break;
        }
    }
}

