/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEncoder {
    protected String projectVersion;
    protected String indent;
    protected PrintWriter out;
    protected boolean indentLine;
    protected int indentTimes;

    public XMLEncoder(PrintWriter out) {
        this(out, null, null);
    }

    public XMLEncoder(PrintWriter out, String indent) {
        this(out, indent, null);
    }

    public XMLEncoder(PrintWriter out, String indent, String projectVersion) {
        this.indent = indent;
        this.out = out;
        this.projectVersion = projectVersion;
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public void indent(int i) {
        this.indentTimes += i;
        if (this.indentTimes < 0) {
            this.indentTimes = 0;
        }
    }

    public void print(Map<?, ? extends XMLSerializable> map) {
        for (XMLSerializable xMLSerializable : map.values()) {
            xMLSerializable.encodeAsXML(this);
        }
    }

    public void print(Collection<? extends XMLSerializable> c) {
        for (XMLSerializable xMLSerializable : c) {
            xMLSerializable.encodeAsXML(this);
        }
    }

    public void printProjectVersion() {
        this.printAttribute("project-version", this.projectVersion);
    }

    public void printAttribute(String name, String value) {
        this.printAttribute(name, value, false);
    }

    public void printlnAttribute(String name, String value) {
        this.printAttribute(name, value, true);
    }

    private void printAttribute(String name, String value, boolean lineBreak) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        value = Util.encodeXmlAttribute(value);
        this.printIndent();
        this.out.print(' ');
        this.out.print(name);
        this.out.print("=\"");
        this.out.print(value);
        this.out.print("\"");
        if (lineBreak) {
            this.println();
        }
    }

    public void printProperty(String name, String value) {
        this.printIndent();
        this.out.print("<property");
        this.printAttribute("name", name);
        this.printAttribute("value", value);
        this.out.println("/>");
        this.indentLine = true;
    }

    public void printProperty(String name, boolean b) {
        this.printProperty(name, String.valueOf(b));
    }

    public void printProperty(String name, int i) {
        this.printProperty(name, String.valueOf(i));
    }

    public void print(String text) {
        this.printIndent();
        this.out.print(text);
    }

    public void print(char c) {
        this.printIndent();
        this.out.print(c);
    }

    public void print(boolean b) {
        this.printIndent();
        this.out.print(b);
    }

    public void print(int i) {
        this.printIndent();
        this.out.print(i);
    }

    public void println(String text) {
        this.printIndent();
        this.out.println(text);
        this.indentLine = true;
    }

    public void println() {
        this.out.println();
        this.indentLine = true;
    }

    public void println(char c) {
        this.printIndent();
        this.out.println(c);
        this.indentLine = true;
    }

    private void printIndent() {
        if (this.indentLine) {
            this.indentLine = false;
            if (this.indentTimes > 0 && this.indent != null) {
                for (int i = 0; i < this.indentTimes; ++i) {
                    this.out.print(this.indent);
                }
            }
        }
    }
}

