/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.access.DefaultDataRowStoreFactory;
import org.apache.cayenne.access.DefaultObjectMapRetainStrategy;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.access.dbsync.DefaultSchemaUpdateStrategyFactory;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyFactory;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.DefaultRowReaderFactory;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslatorFactory;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslatorFactory;
import org.apache.cayenne.access.translator.select.SelectTranslatorFactory;
import org.apache.cayenne.access.types.BigDecimalType;
import org.apache.cayenne.access.types.BigIntegerValueType;
import org.apache.cayenne.access.types.BooleanType;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CalendarType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.CharacterValueType;
import org.apache.cayenne.access.types.DateType;
import org.apache.cayenne.access.types.DefaultValueObjectTypeRegistry;
import org.apache.cayenne.access.types.DoubleType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.FloatType;
import org.apache.cayenne.access.types.IntegerType;
import org.apache.cayenne.access.types.LocalDateTimeValueType;
import org.apache.cayenne.access.types.LocalDateValueType;
import org.apache.cayenne.access.types.LocalTimeValueType;
import org.apache.cayenne.access.types.LongType;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.access.types.TimeType;
import org.apache.cayenne.access.types.TimestampType;
import org.apache.cayenne.access.types.UUIDValueType;
import org.apache.cayenne.access.types.UtilDateType;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.access.types.VoidType;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.cache.MapQueryCacheProvider;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.DefaultDataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DefaultObjectStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataContextFactory;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDataNodeFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.configuration.server.DelegatingDataSourceFactory;
import org.apache.cayenne.configuration.server.DomainDataChannelProvider;
import org.apache.cayenne.configuration.server.PkGeneratorFactoryProvider;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.DefaultHandlerFactory;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.configuration.xml.NoopDataChannelMetaData;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.xml.XMLDataMapLoader;
import org.apache.cayenne.configuration.xml.XMLReaderProvider;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.db2.DB2Adapter;
import org.apache.cayenne.dba.db2.DB2PkGenerator;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbyAdapter;
import org.apache.cayenne.dba.derby.DerbyPkGenerator;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.firebird.FirebirdSniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseAdapter;
import org.apache.cayenne.dba.frontbase.FrontBasePkGenerator;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Adapter;
import org.apache.cayenne.dba.h2.H2PkGenerator;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresAdapter;
import org.apache.cayenne.dba.ingres.IngresPkGenerator;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mariadb.MariaDBSniffer;
import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.dba.mysql.MySQLPkGenerator;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseAdapter;
import org.apache.cayenne.dba.openbase.OpenBasePkGenerator;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.Oracle8Adapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OraclePkGenerator;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresAdapter;
import org.apache.cayenne.dba.postgres.PostgresPkGenerator;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerAdapter;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseAdapter;
import org.apache.cayenne.dba.sybase.SybasePkGenerator;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventManagerProvider;
import org.apache.cayenne.event.NoopEventBridgeProvider;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.template.CayenneSQLTemplateProcessor;
import org.apache.cayenne.template.DefaultTemplateContextFactory;
import org.apache.cayenne.template.TemplateContextFactory;
import org.apache.cayenne.tx.DefaultTransactionFactory;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionFilter;
import org.apache.cayenne.tx.TransactionManager;
import org.xml.sax.XMLReader;

public class ServerModule
implements Module {
    private static final int DEFAULT_MAX_ID_QUALIFIER_SIZE = 10000;

    public static void useExternalTransactions(Binder binder, boolean useExternal) {
        ServerModule.contributeProperties(binder).put("cayenne.server.external_tx", String.valueOf(useExternal));
    }

    public static void setSnapshotCacheSize(Binder binder, int size) {
        ServerModule.contributeProperties(binder).put("cayenne.DataRowStore.snapshot.size", Integer.toString(size));
    }

    public static ListBuilder<String> contributeProjectLocations(Binder binder) {
        return binder.bindList(String.class, "cayenne.server.project_locations");
    }

    @Deprecated
    public static ListBuilder<DataChannelFilter> contributeDomainFilters(Binder binder) {
        return binder.bindList(DataChannelFilter.class, "cayenne.server.domain_filters");
    }

    public static ListBuilder<DataChannelQueryFilter> contributeDomainQueryFilters(Binder binder) {
        return binder.bindList(DataChannelQueryFilter.class);
    }

    public static ListBuilder<DataChannelSyncFilter> contributeDomainSyncFilters(Binder binder) {
        return binder.bindList(DataChannelSyncFilter.class);
    }

    public static ListBuilder<Object> contributeDomainListeners(Binder binder) {
        return binder.bindList(Object.class, "cayenne.server.domain_listeners");
    }

    public static ListBuilder<DbAdapterDetector> contributeAdapterDetectors(Binder binder) {
        return binder.bindList(DbAdapterDetector.class, "cayenne.server.adapter_detectors");
    }

    public static MapBuilder<PkGenerator> contributePkGenerators(Binder binder) {
        return binder.bindMap(PkGenerator.class);
    }

    public static MapBuilder<String> contributeProperties(Binder binder) {
        return binder.bindMap(String.class, "cayenne.properties");
    }

    public static ListBuilder<ExtendedTypeFactory> contributeTypeFactories(Binder binder) {
        return binder.bindList(ExtendedTypeFactory.class, "cayenne.server.type_factories");
    }

    public static ListBuilder<ExtendedType> contributeDefaultTypes(Binder binder) {
        return binder.bindList(ExtendedType.class, "cayenne.server.default_types");
    }

    public static ListBuilder<ExtendedType> contributeUserTypes(Binder binder) {
        return binder.bindList(ExtendedType.class, "cayenne.server.user_types");
    }

    public static ListBuilder<ValueObjectType> contributeValueObjectTypes(Binder binder) {
        return binder.bindList(ValueObjectType.class);
    }

    @Override
    public void configure(Binder binder) {
        ServerModule.contributeProperties(binder).put("cayenne.server.max_id_qualifier_size", String.valueOf(10000));
        ServerModule.contributeProperties(binder).put("cayenne.server.contexts_sync_strategy", String.valueOf(false));
        binder.bind(JdbcEventLogger.class).to(Slf4jJdbcEventLogger.class);
        binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
        binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
        ServerModule.contributeAdapterDetectors(binder).add((DbAdapterDetector)((Object)FirebirdSniffer.class)).add((Class<FirebirdSniffer>)OpenBaseSniffer.class).add((Class<OpenBaseSniffer>)FrontBaseSniffer.class).add((Class<FrontBaseSniffer>)IngresSniffer.class).add((Class<IngresSniffer>)SQLiteSniffer.class).add((Class<SQLiteSniffer>)DB2Sniffer.class).add((Class<DB2Sniffer>)H2Sniffer.class).add((Class<H2Sniffer>)HSQLDBSniffer.class).add((Class<HSQLDBSniffer>)SybaseSniffer.class).add((Class<SybaseSniffer>)DerbySniffer.class).add((Class<DerbySniffer>)SQLServerSniffer.class).add((Class<SQLServerSniffer>)OracleSniffer.class).add((Class<OracleSniffer>)PostgresSniffer.class).add((Class<PostgresSniffer>)MySQLSniffer.class).add((Class<MySQLSniffer>)MariaDBSniffer.class);
        binder.bind(PkGeneratorFactoryProvider.class).to(PkGeneratorFactoryProvider.class);
        binder.bind(PkGenerator.class).to(JdbcPkGenerator.class);
        ServerModule.contributePkGenerators(binder).put(DB2Adapter.class.getName(), (PkGenerator)((Object)DB2PkGenerator.class)).put(DerbyAdapter.class.getName(), (Class<DB2PkGenerator>)DerbyPkGenerator.class).put(FrontBaseAdapter.class.getName(), (Class<DerbyPkGenerator>)FrontBasePkGenerator.class).put(H2Adapter.class.getName(), (Class<FrontBasePkGenerator>)H2PkGenerator.class).put(IngresAdapter.class.getName(), (Class<H2PkGenerator>)IngresPkGenerator.class).put(MySQLAdapter.class.getName(), (Class<IngresPkGenerator>)MySQLPkGenerator.class).put(OpenBaseAdapter.class.getName(), (Class<MySQLPkGenerator>)OpenBasePkGenerator.class).put(OracleAdapter.class.getName(), (Class<OpenBasePkGenerator>)OraclePkGenerator.class).put(Oracle8Adapter.class.getName(), OraclePkGenerator.class).put(PostgresAdapter.class.getName(), (Class<OraclePkGenerator>)PostgresPkGenerator.class).put(SQLServerAdapter.class.getName(), (Class<PostgresPkGenerator>)SybasePkGenerator.class).put(SybaseAdapter.class.getName(), SybasePkGenerator.class);
        ServerModule.contributeDomainFilters(binder);
        ServerModule.contributeDomainQueryFilters(binder);
        ServerModule.contributeDomainSyncFilters(binder).add((DataChannelSyncFilter)((Object)TransactionFilter.class));
        ServerModule.contributeDomainListeners(binder);
        ServerModule.contributeDefaultTypes(binder).add(new VoidType()).add(new BigDecimalType()).add(new BooleanType()).add(new ByteType(false)).add(new CharType(false, true)).add(new DoubleType()).add(new FloatType()).add(new IntegerType()).add(new LongType()).add(new ShortType(false)).add(new ByteArrayType(false, true)).add(new DateType()).add(new TimeType()).add(new TimestampType()).add(new UtilDateType()).add(new CalendarType<GregorianCalendar>(GregorianCalendar.class)).add(new CalendarType<Calendar>(Calendar.class));
        ServerModule.contributeUserTypes(binder);
        ServerModule.contributeTypeFactories(binder);
        ServerModule.contributeValueObjectTypes(binder).add((ValueObjectType)((Object)BigIntegerValueType.class)).add((Class<BigIntegerValueType>)UUIDValueType.class).add((Class<UUIDValueType>)LocalDateValueType.class).add((Class<LocalDateValueType>)LocalTimeValueType.class).add((Class<LocalTimeValueType>)LocalDateTimeValueType.class).add((Class<LocalDateTimeValueType>)CharacterValueType.class);
        binder.bind(ValueObjectTypeRegistry.class).to(DefaultValueObjectTypeRegistry.class);
        ServerModule.contributeProjectLocations(binder);
        binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
        binder.bind(EventManager.class).toProvider(EventManagerProvider.class);
        binder.bind(QueryCache.class).toProvider(MapQueryCacheProvider.class);
        binder.bind(EventBridge.class).toProvider(NoopEventBridgeProvider.class);
        binder.bind(DataRowStoreFactory.class).to(DefaultDataRowStoreFactory.class);
        binder.bind(DataDomain.class).toProvider(DataDomainProvider.class);
        binder.bind(DataNodeFactory.class).to(DefaultDataNodeFactory.class);
        binder.bind(DataChannel.class).toProvider(DomainDataChannelProvider.class);
        binder.bind(ObjectContextFactory.class).to(DataContextFactory.class);
        binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
        binder.bind(DataChannelDescriptorLoader.class).to(XMLDataChannelDescriptorLoader.class);
        binder.bind(DataChannelDescriptorMerger.class).to(DefaultDataChannelDescriptorMerger.class);
        binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
        binder.bind(ResourceLocator.class).to(ClassLoaderResourceLocator.class);
        binder.bind(Key.get(ResourceLocator.class, "cayenne.server.resource_locator")).to(ClassLoaderResourceLocator.class);
        binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
        binder.bind(DataSourceFactory.class).to(DelegatingDataSourceFactory.class);
        binder.bind(SchemaUpdateStrategyFactory.class).to(DefaultSchemaUpdateStrategyFactory.class);
        binder.bind(DbAdapterFactory.class).to(DefaultDbAdapterFactory.class);
        binder.bind(EntitySorter.class).to(AshwoodEntitySorter.class).withoutScope();
        binder.bind(BatchTranslatorFactory.class).to(DefaultBatchTranslatorFactory.class);
        binder.bind(SelectTranslatorFactory.class).to(DefaultSelectTranslatorFactory.class);
        binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
        binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
        binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
        binder.bind(RowReaderFactory.class).to(DefaultRowReaderFactory.class);
        binder.bind(SQLTemplateProcessor.class).to(CayenneSQLTemplateProcessor.class);
        binder.bind(TemplateContextFactory.class).to(DefaultTemplateContextFactory.class);
        binder.bind(HandlerFactory.class).to(DefaultHandlerFactory.class);
        binder.bind(DataChannelMetaData.class).to(NoopDataChannelMetaData.class);
        binder.bind(XMLReader.class).toProviderInstance(new XMLReaderProvider(false)).withoutScope();
    }
}

