/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class IncludeTableHandler
extends NamespaceAwareNestedTagHandler {
    private static final String INCLUDE_TABLE_TAG = "includeTable";
    private static final String INCLUDE_TABLE_NAME_TAG = "name";
    private static final String INCLUDE_COLUMN_TAG = "includeColumn";
    private static final String EXCLUDE_COLUMN_TAG = "excludeColumn";
    private IncludeTable includeTable;
    private FilterContainer entity;

    IncludeTableHandler(NamespaceAwareNestedTagHandler parentHandler, FilterContainer entity) {
        super(parentHandler);
        this.entity = entity;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "includeTable": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processCharData(String localName, String data) {
        switch (localName) {
            case "name": {
                this.createIncludeTableName(data);
                break;
            }
            case "includeColumn": {
                this.createIncludeColumn(data);
                break;
            }
            case "excludeColumn": {
                this.createExcludeColumn(data);
            }
        }
    }

    private void createExcludeColumn(String excludeColumn) {
        if (excludeColumn.trim().length() == 0) {
            return;
        }
        if (this.includeTable != null) {
            this.includeTable.addExcludeColumn(new ExcludeColumn(excludeColumn));
        }
    }

    private void createIncludeColumn(String includeColumn) {
        if (includeColumn.trim().length() == 0) {
            return;
        }
        if (this.includeTable != null) {
            this.includeTable.addIncludeColumn(new IncludeColumn(includeColumn));
        }
    }

    private void createIncludeTableName(String includeTableName) {
        if (includeTableName.trim().length() == 0) {
            return;
        }
        if (this.includeTable == null) {
            this.createIncludeTable();
        }
        if (this.includeTable != null) {
            this.includeTable.setName(includeTableName);
        }
    }

    private void createIncludeTable() {
        this.includeTable = new IncludeTable();
        this.entity.addIncludeTable(this.includeTable);
    }
}

