/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

final class DataDomainIndirectDiffBuilder
implements GraphChangeHandler {
    private final DataDomainFlushAction parent;
    private final EntityResolver resolver;
    private final Collection<ObjectId> indirectModifications;
    private final Collection<FlattenedArcKey> flattenedInserts;
    private final Collection<FlattenedArcKey> flattenedDeletes;

    DataDomainIndirectDiffBuilder(DataDomainFlushAction parent) {
        this.parent = parent;
        this.indirectModifications = parent.getResultIndirectlyModifiedIds();
        this.resolver = parent.getDomain().getEntityResolver();
        this.flattenedInserts = new HashSet<FlattenedArcKey>();
        this.flattenedDeletes = new HashSet<FlattenedArcKey>();
    }

    void processIndirectChanges(GraphDiff allChanges) {
        DbEntity entity;
        allChanges.apply(this);
        if (!this.flattenedInserts.isEmpty()) {
            for (FlattenedArcKey key : this.flattenedInserts) {
                entity = key.getJoinEntity();
                this.parent.addFlattenedInsert(entity, key);
            }
        }
        if (!this.flattenedDeletes.isEmpty()) {
            for (FlattenedArcKey key : this.flattenedDeletes) {
                entity = key.getJoinEntity();
                this.parent.addFlattenedDelete(entity, key);
            }
        }
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjEntity entity = this.resolver.getObjEntity(((ObjectId)nodeId).getEntityName());
        ObjRelationship relationship = entity.getRelationship(arcId.toString());
        if (relationship.isSourceIndependentFromTargetChange()) {
            ObjectId nodeObjectId = (ObjectId)nodeId;
            if (!nodeObjectId.isTemporary()) {
                this.indirectModifications.add(nodeObjectId);
            }
            if (relationship.isFlattened()) {
                FlattenedArcKey key;
                if (relationship.isReadOnly()) {
                    throw new CayenneRuntimeException("Cannot set the read-only flattened relationship '%s' in ObjEntity '%s'.", relationship.getName(), relationship.getSourceEntity().getName());
                }
                StringBuilder path = new StringBuilder();
                for (int i = 0; i < relationship.getDbRelationships().size() - 1; ++i) {
                    if (path.length() > 0) {
                        path.append('.');
                    }
                    path.append(relationship.getDbRelationships().get(i).getName());
                }
                if (!this.parent.getContext().getObjectStore().hasFlattenedPath(nodeObjectId, path.toString()) && !this.flattenedDeletes.remove(key = new FlattenedArcKey(nodeObjectId, (ObjectId)targetNodeId, relationship))) {
                    this.flattenedInserts.add(key);
                }
            }
        }
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjEntity entity = this.resolver.getObjEntity(((ObjectId)nodeId).getEntityName());
        ObjRelationship relationship = entity.getRelationship(arcId.toString());
        if (relationship.isSourceIndependentFromTargetChange()) {
            ObjectId nodeObjectId = (ObjectId)nodeId;
            if (!nodeObjectId.isTemporary()) {
                this.indirectModifications.add(nodeObjectId);
            }
            if (relationship.isFlattened()) {
                FlattenedArcKey key;
                if (relationship.isReadOnly()) {
                    throw new CayenneRuntimeException("Cannot unset the read-only flattened relationship %s", relationship.getName());
                }
                StringBuilder path = new StringBuilder();
                for (int i = 0; i < relationship.getDbRelationships().size() - 1; ++i) {
                    if (path.length() > 0) {
                        path.append('.');
                    }
                    path.append(relationship.getDbRelationships().get(i).getName());
                }
                if (!this.parent.getContext().getObjectStore().hasFlattenedPath(nodeObjectId, path.toString()) && !this.flattenedInserts.remove(key = new FlattenedArcKey(nodeObjectId, (ObjectId)targetNodeId, relationship))) {
                    this.flattenedDeletes.add(key);
                }
            }
        }
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    @Override
    public void nodeCreated(Object nodeId) {
    }

    @Override
    public void nodeRemoved(Object nodeId) {
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
    }
}

