/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.ashwood.graph.Digraph;
import org.apache.cayenne.ashwood.graph.IndegreeTopologicalSort;
import org.apache.cayenne.ashwood.graph.MapDigraph;
import org.apache.cayenne.ashwood.graph.StrongConnection;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.reflect.ClassDescriptor;

public class AshwoodEntitySorter
implements EntitySorter {
    protected EntityResolver entityResolver;
    protected Map<DbEntity, ComponentRecord> components;
    protected Map<DbEntity, List<DbRelationship>> reflexiveDbEntities;
    protected Comparator<DbEntity> dbEntityComparator = new DbEntityComparator();
    protected Comparator<ObjEntity> objEntityComparator = new ObjEntityComparator();
    private volatile boolean dirty = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexSorter() {
        boolean localDirty = this.dirty;
        if (localDirty) {
            AshwoodEntitySorter ashwoodEntitySorter = this;
            synchronized (ashwoodEntitySorter) {
                localDirty = this.dirty;
                if (localDirty) {
                    this.doIndexSorter();
                    this.dirty = false;
                }
            }
        }
    }

    protected void doIndexSorter() {
        HashMap<DbEntity, List<DbRelationship>> reflexiveDbEntities = new HashMap<DbEntity, List<DbRelationship>>();
        MapDigraph<DbEntity, ArrayList<DbAttribute>> referentialDigraph = new MapDigraph<DbEntity, ArrayList<DbAttribute>>();
        if (this.entityResolver != null) {
            for (DbEntity entity : this.entityResolver.getDbEntities()) {
                referentialDigraph.addVertex(entity);
            }
        }
        for (DbEntity destination : this.entityResolver.getDbEntities()) {
            for (DbRelationship candidate : destination.getRelationships()) {
                if ((candidate.isToMany() || candidate.isToDependentPK()) && !candidate.isToMasterPK()) continue;
                DbEntity origin = candidate.getTargetEntity();
                boolean newReflexive = destination.equals(origin);
                for (DbJoin join : candidate.getJoins()) {
                    ArrayList<DbAttribute> fks;
                    DbAttribute targetAttribute = join.getTarget();
                    if (!targetAttribute.isPrimaryKey()) continue;
                    if (newReflexive) {
                        List reflexiveRels = reflexiveDbEntities.computeIfAbsent(destination, k -> new ArrayList(1));
                        reflexiveRels.add(candidate);
                        newReflexive = false;
                    }
                    if ((fks = (ArrayList<DbAttribute>)referentialDigraph.getArc(origin, destination)) == null) {
                        fks = new ArrayList<DbAttribute>();
                        referentialDigraph.putArc(origin, destination, fks);
                    }
                    fks.add(targetAttribute);
                }
            }
        }
        StrongConnection contractor = new StrongConnection(referentialDigraph);
        MapDigraph contractedReferentialDigraph = new MapDigraph();
        contractor.contract(contractedReferentialDigraph);
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(contractedReferentialDigraph);
        HashMap<DbEntity, ComponentRecord> components = new HashMap<DbEntity, ComponentRecord>(contractedReferentialDigraph.order());
        int componentIndex = 0;
        while (sorter.hasNext()) {
            Collection<DbEntity> component = sorter.next();
            ComponentRecord rec = new ComponentRecord(componentIndex++, component);
            for (DbEntity table : component) {
                components.put(table, rec);
            }
        }
        this.reflexiveDbEntities = reflexiveDbEntities;
        this.components = components;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.entityResolver.setEntitySorter(this);
        this.dirty = true;
    }

    @Override
    public void sortDbEntities(List<DbEntity> dbEntities, boolean deleteOrder) {
        this.indexSorter();
        dbEntities.sort(this.getDbEntityComparator(deleteOrder));
    }

    @Override
    public void sortObjEntities(List<ObjEntity> objEntities, boolean deleteOrder) {
        this.indexSorter();
        objEntities.sort(this.getObjEntityComparator(deleteOrder));
    }

    @Override
    public void sortObjectsForEntity(ObjEntity objEntity, List<?> objects, boolean deleteOrder) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        this.indexSorter();
        DbEntity dbEntity = objEntity.getDbEntity();
        if (!this.isReflexive(dbEntity)) {
            return;
        }
        Object probe = objects.get(0);
        if (probe instanceof DbRowOp) {
            this.sortObjectsForEntity(objEntity, objects, deleteOrder, DbRowOp::getObject);
        } else if (probe instanceof Persistent) {
            this.sortObjectsForEntity(objEntity, objects, deleteOrder, Function.identity());
        } else {
            throw new IllegalArgumentException("Can sort only Persistent or DbRow objects, got " + probe.getClass().getSimpleName());
        }
    }

    protected <E> void sortObjectsForEntity(ObjEntity objEntity, List<E> objects, boolean deleteOrder, Function<E, Persistent> converter) {
        Digraph<E, Boolean> objectDependencyGraph = this.buildDigraph(objEntity, objects, converter);
        if (!this.topologicalSort(objects, objectDependencyGraph, deleteOrder)) {
            throw new CayenneRuntimeException("Sorting objects for %s failed. Cycles found.", objEntity.getClassName());
        }
    }

    protected <E> Digraph<E, Boolean> buildDigraph(ObjEntity objEntity, List<E> objects, Function<E, Persistent> converter) {
        EntityResolver resolver = converter.apply(objects.get(0)).getObjectContext().getEntityResolver();
        ClassDescriptor descriptor = resolver.getClassDescriptor(objEntity.getName());
        String[] reflexiveRelNames = this.getReflexiveRelationshipsNames(objEntity);
        int size = objects.size();
        MapDigraph<E, Boolean> objectDependencyGraph = new MapDigraph<E, Boolean>();
        Persistent[] masters = new Persistent[reflexiveRelNames.length];
        for (int i = 0; i < size; ++i) {
            E current = objects.get(i);
            objectDependencyGraph.addVertex(current);
            int actualMasterCount = 0;
            for (int k = 0; k < reflexiveRelNames.length; ++k) {
                String reflexiveRelName = reflexiveRelNames[k];
                if (reflexiveRelName == null) continue;
                Persistent persistent = converter.apply(current);
                masters[k] = (Persistent)descriptor.getProperty(reflexiveRelName).readProperty(persistent);
                if (masters[k] == null) {
                    masters[k] = this.findReflexiveMaster(persistent, objEntity.getRelationship(reflexiveRelName), persistent.getObjectId().getEntityName());
                }
                if (masters[k] == null) continue;
                ++actualMasterCount;
            }
            int mastersFound = 0;
            for (int j = 0; j < size && mastersFound < actualMasterCount; ++j) {
                if (i == j) continue;
                E masterCandidate = objects.get(j);
                for (Persistent master : masters) {
                    if (converter.apply(masterCandidate) != master) continue;
                    objectDependencyGraph.putArc(masterCandidate, current, Boolean.TRUE);
                    ++mastersFound;
                }
            }
        }
        return objectDependencyGraph;
    }

    protected <E> boolean topologicalSort(List<E> data, Digraph<E, Boolean> graph, boolean reverse) {
        IndegreeTopologicalSort<E> sorter = new IndegreeTopologicalSort<E>(graph);
        ArrayList<E> sorted = new ArrayList<E>(data.size());
        while (sorter.hasNext()) {
            E o = sorter.next();
            if (o == null) {
                return false;
            }
            sorted.add(o);
        }
        data.clear();
        data.addAll(sorted);
        if (reverse) {
            Collections.reverse(data);
        }
        return true;
    }

    protected String[] getReflexiveRelationshipsNames(ObjEntity objEntity) {
        List<DbRelationship> reflexiveRels = this.reflexiveDbEntities.get(objEntity.getDbEntity());
        String[] reflexiveRelNames = new String[reflexiveRels.size()];
        for (int i = 0; i < reflexiveRelNames.length; ++i) {
            DbRelationship dbRel = reflexiveRels.get(i);
            ObjRelationship objRel = dbRel != null ? objEntity.getRelationshipForDbRelationship(dbRel) : null;
            reflexiveRelNames[i] = objRel != null ? objRel.getName() : null;
        }
        return reflexiveRelNames;
    }

    protected Persistent findReflexiveMaster(Persistent object, ObjRelationship toOneRel, String targetEntityName) {
        DbRelationship finalRel = toOneRel.getDbRelationships().get(0);
        ObjectContext context = object.getObjectContext();
        if (object.getObjectId().isTemporary()) {
            return null;
        }
        ObjectIdQuery query = new ObjectIdQuery(object.getObjectId(), true, 1);
        QueryResponse response = context.getChannel().onQuery(null, query);
        List result = response.firstList();
        if (result == null || result.size() == 0) {
            return null;
        }
        DataRow snapshot = (DataRow)result.get(0);
        ObjectId id = snapshot.createTargetObjectId(targetEntityName, finalRel);
        return id != null ? (Persistent)context.getGraphManager().getNode(id) : null;
    }

    @Override
    public Comparator<DbEntity> getDbEntityComparator() {
        this.indexSorter();
        return this.dbEntityComparator;
    }

    @Override
    public Comparator<ObjEntity> getObjEntityComparator() {
        this.indexSorter();
        return this.objEntityComparator;
    }

    protected Comparator<DbEntity> getDbEntityComparator(boolean dependantFirst) {
        Comparator<DbEntity> c = this.dbEntityComparator;
        if (dependantFirst) {
            c = c.reversed();
        }
        return c;
    }

    protected Comparator<ObjEntity> getObjEntityComparator(boolean dependantFirst) {
        Comparator<ObjEntity> c = this.objEntityComparator;
        if (dependantFirst) {
            c = c.reversed();
        }
        return c;
    }

    @Override
    public boolean isReflexive(DbEntity metadata) {
        this.indexSorter();
        return this.reflexiveDbEntities.containsKey(metadata);
    }

    private final class DbEntityComparator
    implements Comparator<DbEntity> {
        private DbEntityComparator() {
        }

        @Override
        public int compare(DbEntity t1, DbEntity t2) {
            if (t1 == t2) {
                return 0;
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            ComponentRecord rec1 = AshwoodEntitySorter.this.components.get(t1);
            ComponentRecord rec2 = AshwoodEntitySorter.this.components.get(t2);
            if (rec1 == null) {
                throw new NullPointerException("No record for DbEntity: " + t1);
            }
            if (rec2 == null) {
                throw new NullPointerException("No record for DbEntity: " + t2);
            }
            int index1 = rec1.index;
            int index2 = rec2.index;
            int result = Integer.compare(index1, index2);
            if (result != 0 && rec1.component == rec2.component) {
                result = 0;
            }
            return result;
        }
    }

    private final class ObjEntityComparator
    implements Comparator<ObjEntity> {
        private ObjEntityComparator() {
        }

        @Override
        public int compare(ObjEntity o1, ObjEntity o2) {
            if (o1 == o2) {
                return 0;
            }
            DbEntity t1 = o1.getDbEntity();
            DbEntity t2 = o2.getDbEntity();
            return AshwoodEntitySorter.this.dbEntityComparator.compare(t1, t2);
        }
    }

    private static final class ComponentRecord {
        int index;
        Collection<DbEntity> component;

        ComponentRecord(int index, Collection<DbEntity> component) {
            this.index = index;
            this.component = component;
        }
    }
}

