/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactGenerationMode;
import org.apache.cayenne.gen.EntityUtils;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.velocity.context.Context;

public class EntityArtifact
implements Artifact {
    public static String ENTITY_UTILS_KEY = "entityUtils";
    protected ObjEntity entity;

    public EntityArtifact(ObjEntity entity) {
        this.entity = entity;
        this.sortAttributes();
        this.sortRelationships();
    }

    @Override
    public Object getObject() {
        return this.entity;
    }

    @Override
    public String getQualifiedBaseClassName() {
        return this.entity.getSuperClassName() != null ? this.entity.getSuperClassName() : PersistentObject.class.getName();
    }

    @Override
    public String getQualifiedClassName() {
        return this.entity.getClassName();
    }

    public TemplateType getSingleClassType() {
        return TemplateType.ENTITY_SINGLE_CLASS;
    }

    public TemplateType getSubclassType() {
        return TemplateType.ENTITY_SUBCLASS;
    }

    public TemplateType getSuperClassType() {
        return TemplateType.ENTITY_SUPERCLASS;
    }

    @Override
    public TemplateType[] getTemplateTypes(ArtifactGenerationMode mode) {
        switch (mode) {
            case SINGLE_CLASS: {
                return new TemplateType[]{TemplateType.ENTITY_SINGLE_CLASS};
            }
            case GENERATION_GAP: {
                return new TemplateType[]{TemplateType.ENTITY_SUPERCLASS, TemplateType.ENTITY_SUBCLASS};
            }
        }
        return new TemplateType[0];
    }

    @Override
    public void postInitContext(Context context) {
        EntityUtils metadata = new EntityUtils(this.entity.getDataMap(), this.entity, (String)context.get("baseClassName"), (String)context.get("basePackageName"), (String)context.get("superClassName"), (String)context.get("superPackageName"), (String)context.get("subClassName"), (String)context.get("subPackageName"));
        context.put(ENTITY_UTILS_KEY, metadata);
    }

    private void sortAttributes() {
        ArrayList<ObjAttribute> objAttributes = new ArrayList<ObjAttribute>(this.entity.getDeclaredAttributes());
        objAttributes.sort(Comparator.comparing(Attribute::getName));
        for (ObjAttribute attribute : objAttributes) {
            this.entity.removeAttribute(attribute.getName());
            this.entity.addAttribute(attribute);
        }
    }

    private void sortRelationships() {
        ArrayList<ObjRelationship> relationships = new ArrayList<ObjRelationship>(this.entity.getDeclaredRelationships());
        relationships.sort(Comparator.comparing(Relationship::getName));
        for (ObjRelationship relationship : relationships) {
            this.entity.removeRelationship(relationship.getName());
            this.entity.addRelationship(relationship);
        }
    }
}

