/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.event.DataNodeListener;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.configuration.event.DomainListener;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.configuration.event.ProcedureListener;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.configuration.event.QueryListener;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeFactory;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.TreeDragSource;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CutAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.LinkDataMapsAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.swing.components.TopBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectTreeView
extends JTree
implements DomainDisplayListener,
DomainListener,
DataMapDisplayListener,
DataMapListener,
DataNodeDisplayListener,
DataNodeListener,
ObjEntityListener,
ObjEntityDisplayListener,
DbEntityListener,
DbEntityDisplayListener,
QueryListener,
QueryDisplayListener,
ProcedureListener,
ProcedureDisplayListener,
MultipleObjectsDisplayListener,
EmbeddableDisplayListener,
EmbeddableListener {
    private static final Logger logObj = LoggerFactory.getLogger(ProjectTreeView.class);
    private static final Color SELECTION_COLOR = UIManager.getColor("Tree.selectionBackground");
    protected ProjectController mediator;
    protected TreeSelectionListener treeSelectionListener;
    protected TreeWillExpandListener treeWillExpandListener;
    protected JPopupMenu popup;
    private TreeDragSource tds;

    public ProjectTreeView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
        this.initFromModel(Application.getInstance().getProject());
        this.tds = new TreeDragSource(this, 1, mediator);
    }

    private void initView() {
        this.setCellRenderer(CellRenderers.treeRenderer());
        this.setOpaque(false);
        this.setBorder(TopBorder.create());
    }

    private void initController() {
        this.initTreeSelectionListener();
        this.initTreeExpandListener();
        this.addMouseListener(new MouseClickHandler());
        this.setupMediator();
    }

    private void initTreeSelectionListener() {
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] paths = ProjectTreeView.this.getSelectionPaths();
                if (paths != null) {
                    if (paths.length > 1) {
                        ConfigurationNode projectParentPath = null;
                        ConfigurationNode[] projectPaths = new ConfigurationNode[paths.length];
                        boolean commonParentPath = true;
                        for (int i = 0; i < paths.length; ++i) {
                            projectPaths[i] = this.createProjectPath(paths[i]);
                            TreePath parentPath = paths[i].getParentPath();
                            if (i <= 0 || parentPath == null || parentPath.equals(paths[i - 1].getParentPath())) continue;
                            commonParentPath = false;
                        }
                        if (commonParentPath) {
                            TreePath parentPath = paths[0].getParentPath();
                            projectParentPath = this.createProjectPath(parentPath);
                        }
                        ProjectTreeView.this.mediator.fireMultipleObjectsDisplayEvent(new MultipleObjectsDisplayEvent(this, projectPaths, projectParentPath));
                    } else if (paths.length == 1) {
                        ProjectTreeView.this.processSelection(paths[0]);
                    }
                }
            }

            private ConfigurationNode createProjectPath(TreePath treePath) {
                Object[] path = treePath.getPath();
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path[path.length - 1];
                return (ConfigurationNode)treeNode.getUserObject();
            }
        };
        this.addTreeSelectionListener(this.treeSelectionListener);
    }

    private void initTreeExpandListener() {
        this.treeWillExpandListener = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                if (!ProjectTreeView.this.isPathSelected(path) && !ProjectTreeView.this.isSelectionEmpty()) {
                    ProjectTreeView.this.setSelectionPath(path);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                if (!ProjectTreeView.this.isPathSelected(path) && !ProjectTreeView.this.isSelectionEmpty()) {
                    ProjectTreeView.this.setSelectionPath(path);
                }
            }
        };
        this.addTreeWillExpandListener(this.treeWillExpandListener);
    }

    private void setupMediator() {
        this.mediator.addDomainListener(this);
        this.mediator.addDomainDisplayListener(this);
        this.mediator.addDataNodeListener(this);
        this.mediator.addDataNodeDisplayListener(this);
        this.mediator.addDataMapListener(this);
        this.mediator.addDataMapDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addDbEntityListener(this);
        this.mediator.addDbEntityDisplayListener(this);
        this.mediator.addEmbeddableDisplayListener(this);
        this.mediator.addEmbeddableListener(this);
        this.mediator.addProcedureListener(this);
        this.mediator.addProcedureDisplayListener(this);
        this.mediator.addQueryListener(this);
        this.mediator.addQueryDisplayListener(this);
        this.mediator.addMultipleObjectsDisplayListener(this);
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this, CutAction.class, CopyAction.class);
    }

    private void initFromModel(Project project) {
        ProjectTreeModel model = new ProjectTreeModel(project);
        this.setRootVisible(true);
        this.setModel(model);
        this.getSelectionModel().setSelectionMode(4);
    }

    public ProjectTreeModel getProjectModel() {
        return (ProjectTreeModel)this.getModel();
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        while (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Project) {
            Resource resource = ((Project)value).getConfigurationResource();
            return resource != null ? resource.getURL().getPath() : "";
        }
        try {
            if (value instanceof Embeddable) {
                return String.valueOf(PropertyUtils.getProperty(value, "className"));
            }
            return value != null ? String.valueOf(PropertyUtils.getProperty(value, "name")) : "";
        }
        catch (Exception e) {
            logObj.warn("Exception reading property 'name', class " + value.getClass().getName(), e);
            return "";
        }
    }

    @Override
    public void currentDomainChanged(DomainDisplayEvent e) {
        if (!(e.getSource() != this && e.isDomainChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain()});
    }

    @Override
    public void currentDataNodeChanged(DataNodeDisplayEvent e) {
        if (!(e.getSource() != this && e.isDataNodeChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataNode()});
    }

    @Override
    public void currentDataMapChanged(DataMapDisplayEvent e) {
        if (!(e.getSource() != this && e.isDataMapChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap()});
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        e.setEntityChanged(true);
        this.currentEntityChanged(e);
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        e.setEntityChanged(true);
        this.currentEntityChanged(e);
    }

    protected void currentEntityChanged(EntityDisplayEvent e) {
        if (!(e.getSource() != this && e.isEntityChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getEntity()});
    }

    @Override
    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        if (!(e.getSource() != this && e.isProcedureChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getProcedure()});
    }

    @Override
    public void currentQueryChanged(QueryDisplayEvent e) {
        if (!(e.getSource() != this && e.isQueryChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getQuery()});
    }

    @Override
    public void currentObjectsChanged(MultipleObjectsDisplayEvent e, Application application) {
        if (e.getSource() == this || e.getParentNode() == null) {
            return;
        }
        ConfigurationNode[] nodes = e.getNodes();
        TreePath[] treePaths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            DefaultMutableTreeNode treeNode = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getParentNode(), nodes[i]});
            if (treeNode != null) {
                treePaths[i] = new TreePath(treeNode.getPath());
                continue;
            }
            if (e.getParentNode() != nodes[i]) continue;
            treeNode = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getParentNode()});
            treePaths[i] = new TreePath(treeNode.getPath());
        }
        if (!this.isVisible(treePaths[0])) {
            this.makeVisible(treePaths[0]);
            Rectangle bounds = this.getPathBounds(treePaths[0]);
            if (bounds != null) {
                bounds.height = this.getVisibleRect().height;
                this.scrollRectToVisible(bounds);
            }
        }
        this.setSelectionPaths(treePaths);
    }

    @Override
    public void procedureAdded(ProcedureEvent e) {
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(new Object[]{this.mediator.getProject().getRootNode(), e.getProcedure().getDataMap()});
        if (node == null) {
            return;
        }
        Procedure procedure = e.getProcedure();
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(procedure, false);
        this.positionNode(node, currentNode, Comparators.getDataMapChildrenComparator());
        this.showNode(currentNode);
    }

    @Override
    public void procedureChanged(ProcedureEvent e) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{this.mediator.getProject().getRootNode(), e.getProcedure().getDataMap(), e.getProcedure()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    @Override
    public void procedureRemoved(ProcedureEvent e) {
        this.removeNode(new Object[]{this.mediator.getProject().getRootNode(), e.getProcedure().getDataMap(), e.getProcedure()});
    }

    @Override
    public void queryAdded(QueryEvent e) {
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getDataMap()});
        if (node == null) {
            return;
        }
        QueryDescriptor query = e.getQuery();
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(query, false);
        this.positionNode(node, currentNode, Comparators.getDataMapChildrenComparator());
        this.showNode(currentNode);
    }

    @Override
    public void queryChanged(QueryEvent e) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getQuery().getDataMap(), e.getQuery()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    @Override
    public void queryRemoved(QueryEvent e) {
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getDataMap(), e.getQuery()});
    }

    @Override
    public void domainChanged(DomainEvent e) {
        Object[] path = new Object[]{e.getDomain()};
        this.updateNode(path);
        if (e.isNameChange()) {
            this.positionNode(path, Comparators.getNamedObjectComparator());
            this.showNode(path);
        }
    }

    @Override
    public void dataNodeChanged(DataNodeEvent e) {
        block4: {
            int mapCount;
            String[] mapsName;
            DataChannelDescriptor domain;
            DefaultMutableTreeNode node;
            block6: {
                block5: {
                    node = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getDataNode()});
                    if (node == null) break block4;
                    if (!e.isNameChange()) break block5;
                    this.positionNode((DefaultMutableTreeNode)node.getParent(), node, Comparators.getDataDomainChildrenComparator());
                    this.showNode(node);
                    break block4;
                }
                this.getProjectModel().nodeChanged(node);
                domain = (DataChannelDescriptor)this.mediator.getProject().getRootNode();
                mapsName = e.getDataNode().getDataMapNames().toArray(new String[0]);
                mapCount = mapsName.length;
                if (mapCount <= node.getChildCount()) break block6;
                for (String aMapsName : mapsName) {
                    boolean found = false;
                    for (int j = 0; j < node.getChildCount(); ++j) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                        if (domain.getDataMap(aMapsName) != child.getUserObject()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DefaultMutableTreeNode newMapNode = new DefaultMutableTreeNode(domain.getDataMap(aMapsName), false);
                    this.positionNode(node, newMapNode, Comparators.getNamedObjectComparator());
                    break block4;
                }
                break block4;
            }
            if (mapCount >= node.getChildCount()) break block4;
            int j = 0;
            while (j < node.getChildCount()) {
                boolean found = false;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                Object obj = child.getUserObject();
                for (String aMapsName : mapsName) {
                    if (domain.getDataMap(aMapsName.toString()) != obj) continue;
                    found = true;
                    ++j;
                }
                if (found) continue;
                this.removeNode(child);
            }
        }
    }

    @Override
    public void dataNodeAdded(DataNodeEvent e) {
        if (e.getSource() == this) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode()});
        if (node == null) {
            return;
        }
        DataNodeDescriptor dataNode = e.getDataNode();
        DefaultMutableTreeNode currentNode = ProjectTreeFactory.wrapProjectNode(dataNode);
        this.positionNode(node, currentNode, Comparators.getDataDomainChildrenComparator());
        this.showNode(currentNode);
    }

    @Override
    public void dataNodeRemoved(DataNodeEvent e) {
        if (e.getSource() == this) {
            return;
        }
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getDataNode()});
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
        Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getDataMap()};
        this.updateNode(path);
        if (e.isNameChange()) {
            this.mediator.updateEntityResolver();
            this.positionNode(path, Comparators.getDataDomainChildrenComparator());
            this.showNode(path);
        }
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
        DataChannelDescriptor dataChannelDescriptor = e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode();
        DefaultMutableTreeNode domainNode = this.getProjectModel().getNodeForObjectPath(new Object[]{dataChannelDescriptor});
        DefaultMutableTreeNode newMapNode = ProjectTreeFactory.wrapProjectNode(e.getDataMap());
        this.mediator.getEntityResolver().addDataMap(e.getDataMap());
        this.positionNode(domainNode, newMapNode, Comparators.getDataDomainChildrenComparator());
        if (!Application.getInstance().getFrameController().getDbImportController().isGlobalImport()) {
            this.showNode(newMapNode);
        } else {
            this.setSelected(newMapNode);
        }
        for (DataNodeDescriptor dataNode : new ArrayList<DataNodeDescriptor>(dataChannelDescriptor.getNodeDescriptors())) {
            for (String dataMapName : dataNode.getDataMapNames()) {
                if (!e.getDataMap().getName().equals(dataMapName)) continue;
                this.mediator.fireDataNodeEvent(new DataNodeEvent((Object)this, dataNode));
            }
        }
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
        DataMap map = e.getDataMap();
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        this.removeNode(new Object[]{dataChannelDescriptor, map});
        this.mediator.getEntityResolver().removeDataMap(e.getDataMap());
        for (DataNodeDescriptor dataNode : new ArrayList<DataNodeDescriptor>(dataChannelDescriptor.getNodeDescriptors())) {
            this.removeNode(new Object[]{dataChannelDescriptor, dataNode, map});
        }
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        this.entityChanged(e);
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        this.entityAdded(e);
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        this.entityRemoved(e);
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
        this.entityChanged(e);
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
        this.entityAdded(e);
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
        this.entityRemoved(e);
    }

    protected void entityChanged(EntityEvent e) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getEntity().getDataMap(), e.getEntity()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    protected void entityAdded(EntityEvent e) {
        Entity<?, ?, ?> entity = e.getEntity();
        DefaultMutableTreeNode mapNode = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getEntity().getDataMap()});
        if (mapNode == null) {
            return;
        }
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(entity, false);
        this.positionNode(mapNode, currentNode, Comparators.getDataMapChildrenComparator());
        this.showNode(currentNode);
    }

    protected void entityRemoved(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), e.getEntity().getDataMap(), e.getEntity()});
    }

    protected void removeNode(DefaultMutableTreeNode toBeRemoved) {
        Object selectedNode = null;
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null) {
            selectedNode = selectionPath.getLastPathComponent();
        }
        if (toBeRemoved == selectedNode) {
            DefaultMutableTreeNode newSelection = toBeRemoved.getNextSibling();
            if (newSelection == null && (newSelection = toBeRemoved.getPreviousSibling()) == null && (newSelection = (DefaultMutableTreeNode)toBeRemoved.getParent()) == null && (newSelection = toBeRemoved.getNextNode()) == null) {
                newSelection = toBeRemoved.getPreviousNode();
            }
            this.showNode(newSelection);
        }
        this.getProjectModel().removeNodeFromParent(toBeRemoved);
    }

    protected void showNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        if (!this.isVisible(path)) {
            this.makeVisible(path);
            Rectangle bounds = this.getPathBounds(path);
            if (bounds != null) {
                bounds.height = this.getVisibleRect().height;
                this.scrollRectToVisible(bounds);
            }
        }
        this.setSelectionPath(path);
    }

    private void setSelected(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        if (!this.isVisible(path)) {
            this.makeVisible(path);
        }
    }

    protected void showNode(Object[] path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node == null) {
            return;
        }
        this.showNode(node);
    }

    protected void updateNode(Object[] path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node != null) {
            this.getProjectModel().nodeChanged(node);
        }
    }

    protected void removeNode(Object[] path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node != null) {
            this.removeNode(node);
        }
    }

    public void processSelection(TreePath path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object[] data = this.getUserObjects(currentNode);
        if (data.length == 0) {
            DomainDisplayEvent domEvent = new DomainDisplayEvent((Object)this, null);
            domEvent.setDomain((DataChannelDescriptor)this.mediator.getProject().getRootNode());
            this.mediator.fireDomainDisplayEvent(domEvent);
            return;
        }
        Object obj = data[data.length - 1];
        if (obj instanceof DataChannelDescriptor) {
            this.mediator.fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, (DataChannelDescriptor)obj));
        } else if (obj instanceof DataMap) {
            if (data.length == 2) {
                this.mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent(this, (DataMap)obj, (DataChannelDescriptor)this.mediator.getProject().getRootNode(), (DataNodeDescriptor)data[data.length - 2]));
            } else if (data.length == 1) {
                this.mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent((Object)this, (DataMap)obj, (DataChannelDescriptor)this.mediator.getProject().getRootNode()));
            }
        } else if (obj instanceof DataNodeDescriptor) {
            if (data.length == 1) {
                this.mediator.fireDataNodeDisplayEvent(new DataNodeDisplayEvent(this, (DataChannelDescriptor)this.mediator.getProject().getRootNode(), (DataNodeDescriptor)obj));
            }
        } else if (obj instanceof Entity) {
            EntityDisplayEvent e = new EntityDisplayEvent((Object)this, (Entity)obj);
            e.setUnselectAttributes(true);
            if (data.length == 3) {
                e.setDataMap((DataMap)data[data.length - 2]);
                e.setDomain((DataChannelDescriptor)this.mediator.getProject().getRootNode());
                e.setDataNode((DataNodeDescriptor)data[data.length - 3]);
            } else if (data.length == 2) {
                e.setDataMap((DataMap)data[data.length - 2]);
                e.setDomain((DataChannelDescriptor)this.mediator.getProject().getRootNode());
            }
            if (obj instanceof ObjEntity) {
                this.mediator.fireObjEntityDisplayEvent(e);
            } else if (obj instanceof DbEntity) {
                this.mediator.fireDbEntityDisplayEvent(e);
            }
        } else if (obj instanceof Embeddable) {
            EmbeddableDisplayEvent e = new EmbeddableDisplayEvent((Object)this, (Embeddable)obj, (DataMap)data[data.length - 2], (DataChannelDescriptor)this.mediator.getProject().getRootNode());
            this.mediator.fireEmbeddableDisplayEvent(e);
        } else if (obj instanceof Procedure) {
            ProcedureDisplayEvent e = new ProcedureDisplayEvent((Object)this, (Procedure)obj, (DataMap)data[data.length - 2], (DataChannelDescriptor)this.mediator.getProject().getRootNode());
            this.mediator.fireProcedureDisplayEvent(e);
        } else if (obj instanceof QueryDescriptor) {
            QueryDisplayEvent e = new QueryDisplayEvent((Object)this, (QueryDescriptor)obj, (DataMap)data[data.length - 2], (DataChannelDescriptor)this.mediator.getProject().getRootNode());
            this.mediator.fireQueryDisplayEvent(e);
        }
        this.scrollPathToVisible(path);
    }

    private Object[] getUserObjects(DefaultMutableTreeNode node) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (!node.isRoot()) {
            list.add(0, node.getUserObject());
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return list.toArray();
    }

    private void positionNode(Object[] path, Comparator<ConfigurationNode> comparator) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getProjectModel().getNodeForObjectPath(path);
        if (node == null) {
            return;
        }
        this.positionNode(null, node, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void positionNode(MutableTreeNode parent, DefaultMutableTreeNode treeNode, Comparator<ConfigurationNode> comparator) {
        this.removeTreeSelectionListener(this.treeSelectionListener);
        try {
            this.getProjectModel().positionNode(parent, treeNode, comparator);
        }
        finally {
            this.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    public TreeSelectionListener getTreeSelectionListener() {
        return this.treeSelectionListener;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.buildMenu(CreateNodeAction.class));
        popup.add(this.buildMenu(CreateDataMapAction.class));
        popup.add(this.buildMenu(CreateObjEntityAction.class));
        popup.add(this.buildMenu(CreateEmbeddableAction.class));
        popup.add(this.buildMenu(CreateDbEntityAction.class));
        popup.add(this.buildMenu(CreateProcedureAction.class));
        popup.add(this.buildMenu(CreateQueryAction.class));
        popup.addSeparator();
        popup.add(this.buildMenu(ObjEntitySyncAction.class));
        popup.add(this.buildMenu(DbEntitySyncAction.class));
        popup.add(this.buildMenu(LinkDataMapsAction.class));
        popup.add(this.buildMenu(RemoveAction.class));
        popup.add(this.buildMenu(CutAction.class));
        popup.add(this.buildMenu(CopyAction.class));
        popup.add(this.buildMenu(PasteAction.class));
        return popup;
    }

    private JMenuItem buildMenu(Class<? extends Action> actionType) {
        CayenneAction action = (CayenneAction)this.mediator.getApplication().getActionManager().getAction(actionType);
        return action.buildMenu();
    }

    @Override
    public void embeddableAdded(EmbeddableEvent e, DataMap map) {
        Embeddable embeddable = e.getEmbeddable();
        DefaultMutableTreeNode mapNode = this.getProjectModel().getNodeForObjectPath(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), map});
        if (mapNode == null) {
            return;
        }
        DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(embeddable, false);
        this.positionNode(mapNode, currentNode, Comparators.getDataMapChildrenComparator());
        this.showNode(currentNode);
    }

    @Override
    public void embeddableChanged(EmbeddableEvent e, DataMap map) {
        if (e.isNameChange()) {
            Object[] path = new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), map, e.getEmbeddable()};
            this.updateNode(path);
            this.positionNode(path, Comparators.getDataMapChildrenComparator());
            this.showNode(path);
        }
    }

    @Override
    public void embeddableRemoved(EmbeddableEvent e, DataMap map) {
        if (e.getSource() == this) {
            return;
        }
        this.removeNode(new Object[]{e.getDomain() != null ? e.getDomain() : (DataChannelDescriptor)this.mediator.getProject().getRootNode(), map, e.getEmbeddable()});
    }

    @Override
    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        e.setEmbeddableChanged(true);
        if (!(e.getSource() != this && e.isEmbeddableChanged() || e.isRefired())) {
            return;
        }
        this.showNode(new Object[]{e.getDomain(), e.getDataMap(), e.getEmbeddable()});
    }

    public void popupMenuFilter() {
        MenuElement element;
        JMenuItem item;
        CutAction cutAction = this.mediator.getApplication().getActionManager().getAction(CutAction.class);
        MenuElement[] menuElementArray = this.popup.getSubElements();
        int n = menuElementArray.length;
        for (int i = 0; i < n && !(item = (JMenuItem)(element = menuElementArray[i])).getAction().equals(cutAction); ++i) {
            item.setVisible(item.isEnabled());
        }
    }

    public TreeDragSource getTds() {
        return this.tds;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getSelectionCount() > 0) {
            g.setColor(SELECTION_COLOR);
            int[] rows = this.getSelectionRows();
            if (rows != null) {
                for (int i : rows) {
                    Rectangle r = this.getRowBounds(i);
                    g.fillRect(0, r.y, this.getWidth(), r.height);
                }
            }
        }
        super.paintComponent(g);
    }

    class MouseClickHandler
    extends MouseAdapter {
        MouseClickHandler() {
        }

        void selectRowForEvent(MouseEvent e) {
            int closestRow = ProjectTreeView.this.getClosestRowForLocation(e.getX(), e.getY());
            Rectangle closestRowBounds = ProjectTreeView.this.getRowBounds(closestRow);
            if ((double)e.getY() >= closestRowBounds.getY() && (double)e.getY() < closestRowBounds.getY() + closestRowBounds.getHeight() && !ProjectTreeView.this.isRowSelected(closestRow)) {
                ProjectTreeView.this.setSelectionRow(closestRow);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.selectRowForEvent(e);
            }
            this.mouseReleased(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.selectRowForEvent(e);
                if (ProjectTreeView.this.popup == null) {
                    ProjectTreeView.this.popup = ProjectTreeView.this.createJPopupMenu();
                }
                ProjectTreeView.this.popupMenuFilter();
                ProjectTreeView.this.popup.show(ProjectTreeView.this, e.getX(), e.getY());
            }
        }
    }
}

