/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.undo.CayenneUndoManager;
import org.apache.cayenne.modeler.undo.UpdateValidationConfigUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.validation.ValidationConfig;

public class UpdateValidationConfigAction
extends CayenneAction {
    public static final String ACTION_NAME = "Update ValidationConfig";
    private static final String CONFIG_PARAM = "config";
    private boolean undoable;

    public UpdateValidationConfigAction(Application application) {
        super(ACTION_NAME, application);
        this.undoable = true;
    }

    protected UpdateValidationConfigAction(String name, Application application) {
        super(name, application);
    }

    public void performAction(Object source) {
        this.performAction(new ActionEvent(source, 1001, null));
    }

    @Override
    public void performAction(ActionEvent e) {
        DataChannelMetaData metaData = this.application.getMetaData();
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.application.getProject().getRootNode();
        ValidationConfig config = (ValidationConfig)this.getValue(CONFIG_PARAM);
        ValidationConfig oldConfig = ValidationConfig.fromMetadata(metaData, dataChannel);
        metaData.add(dataChannel, config);
        if (this.undoable) {
            CayenneUndoManager undoManager = this.application.getUndoManager();
            undoManager.addEdit(new UpdateValidationConfigUndoableEdit(oldConfig, config));
        }
        this.getProjectController().fireDomainEvent(new DomainEvent(e.getSource(), dataChannel));
    }

    public UpdateValidationConfigAction putConfig(ValidationConfig config) {
        this.putValue(CONFIG_PARAM, config);
        return this;
    }

    public UpdateValidationConfigAction setUndoable(boolean undoable) {
        this.undoable = undoable;
        return this;
    }
}

