/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.dialog.pref.CayenneModelerPreferenceEditor;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferences;
import org.apache.cayenne.modeler.dialog.pref.DataSourcePreferences;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialogView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.PreferenceEditor;

public class PreferenceDialog
extends CayenneController {
    public static final String GENERAL_KEY = "General";
    public static final String DATA_SOURCES_KEY = "Local DataSources";
    public static final String CLASS_PATH_KEY = "ClassPath";
    private static final String[] preferenceMenus = new String[]{"General", "Local DataSources", "ClassPath"};
    protected PreferenceDialogView view;
    protected Map<String, CayenneController> detailControllers;
    protected PreferenceEditor editor;

    public PreferenceDialog(CayenneController parent) {
        super(parent);
        Window parentView = parent.getView() instanceof Window ? (Window)parent.getView() : SwingUtilities.getWindowAncestor(parent.getView());
        this.view = parentView instanceof Dialog ? new PreferenceDialogView((Dialog)parentView) : new PreferenceDialogView((Frame)parentView);
        this.detailControllers = new HashMap<String, CayenneController>();
        this.editor = new CayenneModelerPreferenceEditor(this.application);
        this.initBindings();
    }

    protected void initBindings() {
        JList<String> list = this.view.getList();
        list.setListData((String[])preferenceMenus);
        list.addListSelectionListener(e -> this.updateSelection());
        this.view.getCancelButton().addActionListener(e -> this.cancelAction());
        this.view.getSaveButton().addActionListener(e -> this.savePreferencesAction());
    }

    public void updateSelection() {
        String selection = this.view.getList().getSelectedValue();
        if (selection != null) {
            this.view.getDetailLayout().show(this.view.getDetailPanel(), selection);
        }
    }

    public void cancelAction() {
        this.editor.revert();
        this.view.dispose();
    }

    public void savePreferencesAction() {
        this.editor.save();
        this.view.dispose();
    }

    public void showDataSourceEditorAction(Object dataSourceKey) {
        this.configure();
        this.view.getDetailLayout().show(this.view.getDetailPanel(), DATA_SOURCES_KEY);
        DataSourcePreferences controller = (DataSourcePreferences)this.detailControllers.get(DATA_SOURCES_KEY);
        controller.editDataSourceAction(dataSourceKey);
        this.view.setVisible(true);
    }

    public void showClassPathEditorAction() {
        this.configure();
        this.view.getDetailLayout().show(this.view.getDetailPanel(), CLASS_PATH_KEY);
        ClasspathPreferences controller = (ClasspathPreferences)this.detailControllers.get(CLASS_PATH_KEY);
        controller.getView().setEnabled(true);
        this.view.setVisible(true);
    }

    public void startupAction(String key) {
        this.configure();
        this.view.getList().setSelectedValue(key == null ? GENERAL_KEY : key, true);
        this.view.setVisible(true);
    }

    protected void configure() {
        this.registerPanel(GENERAL_KEY, new GeneralPreferences(this));
        this.registerPanel(DATA_SOURCES_KEY, new DataSourcePreferences(this));
        this.registerPanel(CLASS_PATH_KEY, new ClasspathPreferences(this));
        this.view.getDetailLayout().show(this.view.getDetailPanel(), GENERAL_KEY);
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModalityType(Dialog.ModalityType.MODELESS);
    }

    protected void registerPanel(String name, CayenneController panelController) {
        this.detailControllers.put(name, panelController);
        this.view.getDetailPanel().add(panelController.getView(), name);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public PreferenceEditor getEditor() {
        return this.editor;
    }
}

