/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjEntityValidator
extends ConfigurationNodeValidator<ObjEntity> {
    public ObjEntityValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(ObjEntity node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.OBJ_ENTITY_NO_NAME, this::checkForName).performIfEnabled(Inspection.OBJ_ENTITY_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.OBJ_ENTITY_NO_DB_ENTITY, this::checkForDbEntity).performIfEnabled(Inspection.OBJ_ENTITY_INVALID_CLASS, this::validateClassName).performIfEnabled(Inspection.OBJ_ENTITY_INVALID_SUPER_CLASS, this::validateSuperClassName);
    }

    private void checkForName(ObjEntity entity, ValidationResult validationResult) {
        String name = entity.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, entity, "Unnamed ObjEntity", new Object[0]);
        }
    }

    private void checkForNameDuplicates(ObjEntity entity, ValidationResult validationResult) {
        DataChannelDescriptor domain;
        String name = entity.getName();
        DataMap map = entity.getDataMap();
        if (map == null || Util.isEmptyString(name)) {
            return;
        }
        for (ObjEntity otherEnt : map.getObjEntities()) {
            if (otherEnt == entity || !name.equals(otherEnt.getName())) continue;
            this.addFailure(validationResult, entity, "Duplicate ObjEntity name: '%s'", name);
            break;
        }
        if ((domain = entity.getDataMap().getDataChannelDescriptor()) == null) {
            return;
        }
        for (DataMap nextMap : domain.getDataMaps()) {
            ObjEntity conflictingEntity;
            if (nextMap == map || (conflictingEntity = nextMap.getObjEntity(name)) == null || Util.nullSafeEquals(conflictingEntity.getClassName(), entity.getClassName())) continue;
            this.addFailure(validationResult, entity, "Duplicate ObjEntity name in another DataMap: '%s'", name);
            break;
        }
    }

    private void checkForDbEntity(ObjEntity entity, ValidationResult validationResult) {
        if (entity.getDbEntity() == null && !entity.isAbstract()) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' has no DbEntity mapping", entity.getName());
        }
    }

    private void validateClassName(ObjEntity entity, ValidationResult validationResult) {
        String className = entity.getClassName();
        if (Util.isEmptyString(className)) {
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(className);
        if (invalidChars != null) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' Java class '%s' contains invalid characters: %s", entity.getName(), className, invalidChars);
        } else if (helper.invalidPersistentObjectClass(className)) {
            this.addFailure(validationResult, entity, "Java class '%s' of ObjEntity '%s' is a reserved word", className, entity.getName());
        } else if (className.indexOf(46) < 0) {
            this.addFailure(validationResult, entity, "Java class '%s' of ObjEntity '%s' is in a default package", className, entity.getName());
        }
    }

    private void validateSuperClassName(ObjEntity entity, ValidationResult validationResult) {
        String superClassName = entity.getSuperClassName();
        if (Util.isEmptyString(superClassName)) {
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(superClassName);
        if (invalidChars != null) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' Java superclass '%s' contains invalid characters: %s", entity.getName(), superClassName, invalidChars);
        } else if (helper.invalidPersistentObjectClass(superClassName)) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' Java superclass '%s' is a reserved word", entity.getName(), superClassName);
        }
        if (entity.getDbEntityName() != null && entity.getSuperEntityName() != null) {
            this.addFailure(validationResult, entity, "Sub ObjEntity '%s' has database table declaration different from super ObjEntity '%s'", entity.getName(), entity.getSuperEntityName());
        }
    }
}

