/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryRouter;

public class PrefetchSelectQuery<T>
extends ObjectSelect<T> {
    protected CayennePath prefetchPath;
    protected ObjRelationship lastPrefetchHint;
    protected Collection<ASTPath> resultPaths;

    public PrefetchSelectQuery(CayennePath prefetchPath, ObjRelationship lastPrefetchHint) {
        this.entityName(lastPrefetchHint.getTargetEntityName());
        this.prefetchPath = prefetchPath;
        this.lastPrefetchHint = lastPrefetchHint;
    }

    @Override
    protected void routePrefetches(QueryRouter router, EntityResolver resolver) {
    }

    public CayennePath getPrefetchPath() {
        return this.prefetchPath;
    }

    public void setPrefetchPath(String prefetchPath) {
        this.setPrefetchPath(CayennePath.of(prefetchPath));
    }

    public void setPrefetchPath(CayennePath prefetchPath) {
        this.prefetchPath = prefetchPath;
    }

    public void setPrefetchTree(PrefetchTreeNode prefetch) {
        this.getBaseMetaData().setPrefetchTree(prefetch);
    }

    public ObjRelationship getLastPrefetchHint() {
        return this.lastPrefetchHint;
    }

    public void setLastPrefetchHint(ObjRelationship relationship) {
        this.lastPrefetchHint = relationship;
    }

    public void addResultPath(String path) {
        if (path.startsWith("db:")) {
            this.addResultPath(ExpressionFactory.dbPathExp(path));
        } else {
            this.addResultPath(ExpressionFactory.pathExp(path));
        }
    }

    public void addResultPath(Expression path) {
        if (!(path instanceof ASTPath)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        this.nonNullResultPaths().add((ASTPath)path);
    }

    public void removeResultPath(String path) {
        this.removeResultPath(CayennePath.of(path));
    }

    public void removeResultPath(CayennePath path) {
        if (this.resultPaths != null) {
            this.resultPaths.remove(path);
        }
    }

    public Collection<ASTPath> getResultPaths() {
        return this.resultPaths != null ? Collections.unmodifiableCollection(this.resultPaths) : Collections.emptySet();
    }

    Collection<ASTPath> nonNullResultPaths() {
        if (this.resultPaths == null) {
            this.resultPaths = new HashSet<ASTPath>();
        }
        return this.resultPaths;
    }
}

