/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.map.PatternColumnMapper;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.MapBuilder;

public class CryptoModuleExtender {
    private final Binder binder;
    private MapBuilder<String> properties;
    private MapBuilder<char[]> credentials;
    private MapBuilder<BytesConverter<?>> dbToByteConverters;
    private MapBuilder<BytesConverter<?>> objectToByteConverters;

    protected CryptoModuleExtender(Binder binder) {
        this.binder = binder;
    }

    public CryptoModuleExtender cipherAlgorithm(String algorithm) {
        this.contributeProperties(this.binder).put("cayenne.crypto.cipher.algorithm", (Object)algorithm);
        return this;
    }

    public CryptoModuleExtender cipherMode(String mode) {
        this.contributeProperties(this.binder).put("cayenne.crypto.cipher.mode", (Object)mode);
        return this;
    }

    public CryptoModuleExtender cipherPadding(String padding) {
        this.contributeProperties(this.binder).put("cayenne.crypto.cipher.padding", (Object)padding);
        return this;
    }

    public CryptoModuleExtender cipherFactory(Class<? extends CipherFactory> factoryType) {
        this.binder.bind(CipherFactory.class).to(factoryType);
        return this;
    }

    public CryptoModuleExtender valueTransformer(Class<? extends ValueTransformerFactory> factoryType) {
        this.binder.bind(ValueTransformerFactory.class).to(factoryType);
        return this;
    }

    public CryptoModuleExtender bytesTransformer(Class<? extends BytesTransformerFactory> factoryType) {
        this.binder.bind(BytesTransformerFactory.class).to(factoryType);
        return this;
    }

    public <T> CryptoModuleExtender objectToBytesConverter(Class<T> objectType, BytesConverter<T> converter) {
        this.contributeObjectToByteConverters(this.binder).put(CryptoModuleExtender.typeName(objectType), Objects.requireNonNull(converter));
        return this;
    }

    public CryptoModuleExtender dbToBytesConverter(int sqlType, BytesConverter<?> converter) {
        this.contributeDbToByteConverters(this.binder).put(String.valueOf(sqlType), Objects.requireNonNull(converter));
        return this;
    }

    public CryptoModuleExtender columnMapper(Class<? extends ColumnMapper> columnMapperType) {
        this.binder.bind(ColumnMapper.class).to(columnMapperType);
        return this;
    }

    public CryptoModuleExtender columnMapper(ColumnMapper columnMapper) {
        this.binder.bind(ColumnMapper.class).toInstance((Object)columnMapper);
        return this;
    }

    public CryptoModuleExtender columnMapper(String pattern) {
        this.binder.bind(ColumnMapper.class).toInstance((Object)new PatternColumnMapper(pattern));
        return this;
    }

    public CryptoModuleExtender encryptionKeyAlias(String encryptionKeyAlias) {
        this.contributeProperties(this.binder).put("cayenne.crypto.key.enc.alias", (Object)encryptionKeyAlias);
        return this;
    }

    public CryptoModuleExtender keyStore(File file, char[] passwordForAllKeys, String encryptionKeyAlias) {
        try {
            String fileUrl = file.toURI().toURL().toExternalForm();
            return this.keyStore(fileUrl, passwordForAllKeys, encryptionKeyAlias);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid keyStore file", e);
        }
    }

    public CryptoModuleExtender keyStore(URL url, char[] passwordForAllKeys, String encryptionKeyAlias) {
        return this.keyStore(url.toExternalForm(), passwordForAllKeys, encryptionKeyAlias);
    }

    public CryptoModuleExtender keyStore(String url, char[] passwordForAllKeys, String encryptionKeyAlias) {
        MapBuilder<String> propertiesBuilder = this.contributeProperties(this.binder);
        propertiesBuilder.put("cayenne.crypto.keystore.url", (Object)url);
        propertiesBuilder.put("cayenne.crypto.key.enc.alias", (Object)encryptionKeyAlias);
        this.contributeCredentials(this.binder).put("cayenne.crypto.key.password", (Object)passwordForAllKeys);
        return this;
    }

    public CryptoModuleExtender keySource(Class<? extends KeySource> keySourceType) {
        this.binder.bind(KeySource.class).to(keySourceType);
        return this;
    }

    public CryptoModuleExtender keySource(KeySource keySource) {
        this.binder.bind(KeySource.class).toInstance((Object)keySource);
        return this;
    }

    public CryptoModuleExtender compress() {
        this.contributeProperties(this.binder).put("cayenne.crypto.compression", (Object)"true");
        return this;
    }

    public CryptoModuleExtender useHMAC() {
        this.contributeProperties(this.binder).put("cayenne.crypto.use_hmac", (Object)"true");
        return this;
    }

    private MapBuilder<String> contributeProperties(Binder binder) {
        if (this.properties == null) {
            this.properties = binder.bindMap(String.class, "cayenne.crypto.properties");
        }
        return this.properties;
    }

    private MapBuilder<char[]> contributeCredentials(Binder binder) {
        if (this.credentials == null) {
            this.credentials = binder.bindMap(char[].class, "cayenne.crypto.properties");
        }
        return this.credentials;
    }

    private MapBuilder<BytesConverter<?>> contributeDbToByteConverters(Binder binder) {
        if (this.dbToByteConverters == null) {
            MapBuilder mapBuilder;
            this.dbToByteConverters = mapBuilder = binder.bindMap(BytesConverter.class, "org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.dbToBytes");
        }
        return this.dbToByteConverters;
    }

    private MapBuilder<BytesConverter<?>> contributeObjectToByteConverters(Binder binder) {
        if (this.objectToByteConverters == null) {
            MapBuilder mapBuilder;
            this.objectToByteConverters = mapBuilder = binder.bindMap(BytesConverter.class, "org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.objectToBytes");
        }
        return this.objectToByteConverters;
    }

    static <T> String typeName(Class<T> objectType) {
        if (objectType.isArray()) {
            if (objectType.getComponentType().isPrimitive()) {
                return objectType.getComponentType().getSimpleName() + "[]";
            }
            return objectType.getComponentType().getName() + "[]";
        }
        return objectType.getName();
    }
}

