/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.handlers;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public interface UpgradeHandler {
    public static final String CGEN = "cgen";
    public static final String DB_IMPORT = "dbImport";
    public static final String GRAPH = "graph";

    public String getVersion();

    public void processProjectDom(UpgradeUnit var1);

    public void processDataMapDom(UpgradeUnit var1);

    default public void processModel(DataChannelDescriptor dataChannelDescriptor) {
    }

    default public void updateDomainSchemaAndVersion(UpgradeUnit upgradeUnit) {
        Element domain = upgradeUnit.getDocument().getDocumentElement();
        domain.setAttribute("xmlns", "http://cayenne.apache.org/schema/" + this.getVersion() + "/domain");
        domain.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        domain.setAttribute("xsi:schemaLocation", "http://cayenne.apache.org/schema/" + this.getVersion() + "/domain https://cayenne.apache.org/schema/" + this.getVersion() + "/domain.xsd");
        domain.setAttribute("project-version", this.getVersion());
    }

    default public void updateDataMapSchemaAndVersion(UpgradeUnit upgradeUnit) {
        Element dataMap = upgradeUnit.getDocument().getDocumentElement();
        dataMap.setAttribute("xmlns", "http://cayenne.apache.org/schema/" + this.getVersion() + "/modelMap");
        dataMap.setAttribute("xsi:schemaLocation", "http://cayenne.apache.org/schema/" + this.getVersion() + "/modelMap https://cayenne.apache.org/schema/" + this.getVersion() + "/modelMap.xsd");
        dataMap.setAttribute("project-version", this.getVersion());
    }

    default public void updateExtensionSchema(UpgradeUnit upgradeUnit, String extension) {
        NodeList nodes;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            nodes = (NodeList)xpath.evaluate("/data-map/*[local-name()='" + extension + "']", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return;
        }
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element element = (Element)nodes.item(j);
            element.setAttribute("xmlns", "http://cayenne.apache.org/schema/" + this.getVersion() + "/" + extension.toLowerCase());
        }
    }
}

